/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class LoginMode {
    private static final String TAG = "LoginMode";
    @Constant(value=0)
    public static final LoginMode Login;
    @Constant(value=1)
    public static final LoginMode CreateDemo;
    @Constant(value=2)
    public static final LoginMode CreateReal;
    private final int value;
    private static final Map<Integer, LoginMode> map;
    private static LoginMode[] mValues;

    LoginMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LoginMode get(int value) {
        LoginMode val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new LoginMode(value);
            map.put(value, val);
            ArrayList<LoginMode> values = new ArrayList<LoginMode>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new LoginMode[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public LoginMode[] values() {
        return mValues;
    }

    public boolean IsCreateAccount() {
        return this.value != 0;
    }

    public String toString() {
        return "LoginMode(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, LoginMode>();
        ArrayList<LoginMode> values = new ArrayList<LoginMode>();
        Login = new LoginMode(0);
        values.add(Login);
        CreateDemo = new LoginMode(1);
        values.add(CreateDemo);
        CreateReal = new LoginMode(2);
        values.add(CreateReal);
        for (LoginMode t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new LoginMode[values.size()];
        values.toArray(mValues);
    }
}

