/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class LiveAccountRejectReason {
    private static final String TAG = "LiveAccountRejectReason";
    @Constant(value=0)
    public static final LiveAccountRejectReason None;
    @Constant(value=2)
    public static final LiveAccountRejectReason AgeRequirement;
    @Constant(value=5)
    public static final LiveAccountRejectReason IdentityVerification;
    @Constant(value=10)
    public static final LiveAccountRejectReason Unknown;
    private final int value;
    private final String name;
    private static final Map<Integer, LiveAccountRejectReason> map;
    private static final Map<String, LiveAccountRejectReason> nameMap;
    private static LiveAccountRejectReason[] mValues;

    private LiveAccountRejectReason(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static LiveAccountRejectReason get(int value) {
        LiveAccountRejectReason val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new LiveAccountRejectReason(value, "?" + value);
            map.put(value, val);
            ArrayList<LiveAccountRejectReason> values = new ArrayList<LiveAccountRejectReason>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new LiveAccountRejectReason[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static LiveAccountRejectReason fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, LiveAccountRejectReason>();
        nameMap = new HashMap<String, LiveAccountRejectReason>();
        ArrayList<LiveAccountRejectReason> values = new ArrayList<LiveAccountRejectReason>();
        None = new LiveAccountRejectReason(0, "None");
        values.add(None);
        AgeRequirement = new LiveAccountRejectReason(2, "AgeRequirement");
        values.add(AgeRequirement);
        IdentityVerification = new LiveAccountRejectReason(5, "IdentityVerification");
        values.add(IdentityVerification);
        Unknown = new LiveAccountRejectReason(10, "Unknown");
        values.add(Unknown);
        for (LiveAccountRejectReason t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new LiveAccountRejectReason[values.size()];
        values.toArray(mValues);
    }
}

