/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class LiquidationNotificationType {
    private static final String TAG = "LiquidationNotificationType";
    @Constant(value=0)
    public static final LiquidationNotificationType Unspecified;
    @Constant(value=1)
    public static final LiquidationNotificationType MarginViolation;
    @Constant(value=2)
    public static final LiquidationNotificationType MarketExpiring;
    private final int value;
    private final String name;
    private static final Map<Integer, LiquidationNotificationType> map;
    private static final Map<String, LiquidationNotificationType> nameMap;
    private static LiquidationNotificationType[] mValues;

    private LiquidationNotificationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static LiquidationNotificationType get(int value) {
        LiquidationNotificationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new LiquidationNotificationType(value, "?" + value);
            map.put(value, val);
            ArrayList<LiquidationNotificationType> values = new ArrayList<LiquidationNotificationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new LiquidationNotificationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static LiquidationNotificationType fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, LiquidationNotificationType>();
        nameMap = new HashMap<String, LiquidationNotificationType>();
        ArrayList<LiquidationNotificationType> values = new ArrayList<LiquidationNotificationType>();
        Unspecified = new LiquidationNotificationType(0, "Unspecified");
        values.add(Unspecified);
        MarginViolation = new LiquidationNotificationType(1, "MarginViolation");
        values.add(MarginViolation);
        MarketExpiring = new LiquidationNotificationType(2, "MarketExpiring");
        values.add(MarketExpiring);
        for (LiquidationNotificationType t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new LiquidationNotificationType[values.size()];
        values.toArray(mValues);
    }
}

