/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class IdentityStatus {
    private static final String TAG = "IdentityStatus";
    @Constant(value=0)
    public static final IdentityStatus NotStarted;
    @Constant(value=1)
    public static final IdentityStatus Incomplete;
    @Constant(value=2)
    public static final IdentityStatus Pending;
    @Constant(value=3)
    public static final IdentityStatus Complete;
    private final int value;
    private final String name;
    private static final Map<Integer, IdentityStatus> map;
    private static final Map<String, IdentityStatus> nameMap;
    private static IdentityStatus[] mValues;

    private IdentityStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static IdentityStatus get(int value) {
        IdentityStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new IdentityStatus(value, "?" + value);
            map.put(value, val);
            ArrayList<IdentityStatus> values = new ArrayList<IdentityStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new IdentityStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static IdentityStatus fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, IdentityStatus>();
        nameMap = new HashMap<String, IdentityStatus>();
        ArrayList<IdentityStatus> values = new ArrayList<IdentityStatus>();
        NotStarted = new IdentityStatus(0, "NotStarted");
        values.add(NotStarted);
        Incomplete = new IdentityStatus(1, "Incomplete");
        values.add(Incomplete);
        Pending = new IdentityStatus(2, "Pending");
        values.add(Pending);
        Complete = new IdentityStatus(3, "Complete");
        values.add(Complete);
        for (IdentityStatus t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new IdentityStatus[values.size()];
        values.toArray(mValues);
    }
}

