/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class IdentityResult {
    private static final String TAG = "IdentityResult";
    @Constant(value=0)
    public static final IdentityResult Unknown;
    @Constant(value=1)
    public static final IdentityResult Verified;
    @Constant(value=2)
    public static final IdentityResult Failed;
    @Constant(value=3)
    public static final IdentityResult Retry;
    private final int value;
    private final String name;
    private static final Map<Integer, IdentityResult> map;
    private static final Map<String, IdentityResult> nameMap;
    private static IdentityResult[] mValues;

    private IdentityResult(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static IdentityResult get(int value) {
        IdentityResult val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new IdentityResult(value, "?" + value);
            map.put(value, val);
            ArrayList<IdentityResult> values = new ArrayList<IdentityResult>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new IdentityResult[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static IdentityResult fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, IdentityResult>();
        nameMap = new HashMap<String, IdentityResult>();
        ArrayList<IdentityResult> values = new ArrayList<IdentityResult>();
        Unknown = new IdentityResult(0, "Unknown");
        values.add(Unknown);
        Verified = new IdentityResult(1, "Verified");
        values.add(Verified);
        Failed = new IdentityResult(2, "Failed");
        values.add(Failed);
        Retry = new IdentityResult(3, "Retry");
        values.add(Retry);
        for (IdentityResult t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new IdentityResult[values.size()];
        values.toArray(mValues);
    }
}

