/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class DepthLevels {
    private static final String TAG = "DepthLevels";
    @Constant(value=0)
    public static final DepthLevels Undefined;
    @Constant(value=1)
    public static final DepthLevels BestOnly;
    @Constant(value=10)
    public static final DepthLevels Normal;
    @Constant(value=255)
    public static final DepthLevels All;
    private final int value;
    private static Map<Integer, DepthLevels> map;
    private static DepthLevels[] mValues;

    DepthLevels(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DepthLevels get(int value) {
        DepthLevels val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new DepthLevels(value);
            map.put(value, val);
            ArrayList<DepthLevels> values = new ArrayList<DepthLevels>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new DepthLevels[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "DepthLevels(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, DepthLevels>();
        ArrayList<DepthLevels> values = new ArrayList<DepthLevels>();
        Undefined = new DepthLevels(0);
        values.add(Undefined);
        BestOnly = new DepthLevels(1);
        values.add(BestOnly);
        Normal = new DepthLevels(10);
        values.add(Normal);
        All = new DepthLevels(255);
        values.add(All);
        for (DepthLevels t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new DepthLevels[values.size()];
        values.toArray(mValues);
    }
}

