/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class DepthBuffer {
    private static final String TAG = "DepthBuffer";
    @Constant(value=0)
    public static final DepthBuffer NoSubscription;
    @Constant(value=1)
    public static final DepthBuffer SlowTrade;
    @Constant(value=2)
    public static final DepthBuffer SmartTrade;
    @Constant(value=3)
    public static final DepthBuffer SlowSmart;
    @Constant(value=4)
    public static final DepthBuffer Smart;
    @Constant(value=5)
    public static final DepthBuffer FastSmart;
    @Constant(value=6)
    public static final DepthBuffer All;
    @Constant(value=7)
    public static final DepthBuffer FastTrade;
    @Constant(value=8)
    public static final DepthBuffer TradeOnly;
    private final int value;
    private final boolean isTradeFeed;
    private final String name;
    private static Map<Integer, DepthBuffer> map;
    private static DepthBuffer[] mValues;

    DepthBuffer(int value, boolean isTrade, String nm) {
        this.value = value;
        this.isTradeFeed = isTrade;
        this.name = nm;
    }

    public int getValue() {
        return this.value;
    }

    public boolean getIsTradeFeed() {
        return this.isTradeFeed;
    }

    public static DepthBuffer get(int value) {
        DepthBuffer val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new DepthBuffer(value, false, "DepthBuffer(" + value + ")");
            map.put(value, val);
            ArrayList<DepthBuffer> values = new ArrayList<DepthBuffer>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new DepthBuffer[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, DepthBuffer>();
        ArrayList<DepthBuffer> values = new ArrayList<DepthBuffer>();
        NoSubscription = new DepthBuffer(0, false, "NoSubscription");
        values.add(NoSubscription);
        SlowTrade = new DepthBuffer(1, true, "SlowTrade");
        values.add(SlowTrade);
        SmartTrade = new DepthBuffer(2, true, "SmartTrade");
        values.add(SmartTrade);
        SlowSmart = new DepthBuffer(3, false, "SlowSmart");
        values.add(SlowSmart);
        Smart = new DepthBuffer(4, false, "Smart");
        values.add(Smart);
        FastSmart = new DepthBuffer(5, false, "FastSmart");
        values.add(FastSmart);
        All = new DepthBuffer(6, true, "All");
        values.add(All);
        FastTrade = new DepthBuffer(7, true, "FastTrade");
        values.add(FastTrade);
        TradeOnly = new DepthBuffer(8, true, "TradeOnly");
        values.add(TradeOnly);
        for (DepthBuffer t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new DepthBuffer[values.size()];
        values.toArray(mValues);
    }
}

