/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class DaysToExpiryCalculationType {
    private static final String TAG = "DaysToExpiryCalculationType";
    @Constant(value=0)
    public static final DaysToExpiryCalculationType Calendar;
    @Constant(value=1)
    public static final DaysToExpiryCalculationType Weekdays;
    private final int value;
    private static final Map<Integer, DaysToExpiryCalculationType> map;
    private static DaysToExpiryCalculationType[] mValues;

    DaysToExpiryCalculationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DaysToExpiryCalculationType get(int value) {
        DaysToExpiryCalculationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new DaysToExpiryCalculationType(value);
            map.put(value, val);
            ArrayList<DaysToExpiryCalculationType> values = new ArrayList<DaysToExpiryCalculationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new DaysToExpiryCalculationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public DaysToExpiryCalculationType[] values() {
        return mValues;
    }

    public String toString() {
        return "DaysToExpiryCalculationType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, DaysToExpiryCalculationType>();
        ArrayList<DaysToExpiryCalculationType> values = new ArrayList<DaysToExpiryCalculationType>();
        Calendar = new DaysToExpiryCalculationType(0);
        values.add(Calendar);
        Weekdays = new DaysToExpiryCalculationType(1);
        values.add(Weekdays);
        for (DaysToExpiryCalculationType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new DaysToExpiryCalculationType[values.size()];
        values.toArray(mValues);
    }
}

