/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.util.SortUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ContractType
implements Comparable<ContractType>,
Serializable {
    private static final String TAG = "ContractType";
    @Constant(value=-1)
    public static final ContractType Any;
    @Constant(value=0)
    public static final ContractType Unknown;
    @Constant(value=1)
    public static final ContractType Option;
    @Constant(value=2)
    public static final ContractType OptionCall;
    @Constant(value=3)
    public static final ContractType OptionPut;
    @Constant(value=4)
    public static final ContractType Stock;
    @Constant(value=5)
    public static final ContractType Future;
    @Constant(value=6)
    public static final ContractType Index;
    @Constant(value=7)
    public static final ContractType Synthetic;
    @Constant(value=8)
    public static final ContractType BinaryOption;
    @Constant(value=9)
    public static final ContractType UDS;
    @Constant(value=10)
    public static final ContractType FXSpot;
    private final int value;
    private final String name;
    private static Map<Integer, ContractType> map;
    private static Map<String, ContractType> names;
    private static ContractType[] mValues;

    private ContractType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public static ContractType get(int value) {
        ContractType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ContractType(value, Integer.toString(value));
            map.put(value, val);
            names.put(val.name, val);
            ArrayList<ContractType> values = new ArrayList<ContractType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ContractType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static ContractType valueOf(String name) {
        return names.get(name);
    }

    public ContractType[] values() {
        return mValues;
    }

    public String toString() {
        return "ContractType(" + this.getValue() + ")";
    }

    public static boolean isOption(ContractType t) {
        return t == Option || t == OptionCall || t == OptionPut;
    }

    @Override
    public int compareTo(ContractType contractType) {
        return SortUtil.compare(this.getValue(), contractType.getValue());
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ContractType && this.value == ((ContractType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, ContractType>();
        names = new HashMap<String, ContractType>();
        ArrayList<ContractType> values = new ArrayList<ContractType>();
        Any = new ContractType(-1, TAG);
        values.add(Any);
        Unknown = new ContractType(0, "Unknown");
        values.add(Unknown);
        Option = new ContractType(1, "Option");
        values.add(Option);
        OptionCall = new ContractType(2, "OptionCall");
        values.add(OptionCall);
        OptionPut = new ContractType(3, "OptionPut");
        values.add(OptionPut);
        Stock = new ContractType(4, "Stock");
        values.add(Stock);
        Future = new ContractType(5, "Future");
        values.add(Future);
        Index = new ContractType(6, "Index");
        values.add(Index);
        Synthetic = new ContractType(7, "Synthetic");
        values.add(Synthetic);
        BinaryOption = new ContractType(8, "BinaryOption");
        values.add(BinaryOption);
        UDS = new ContractType(9, "UDS");
        values.add(UDS);
        FXSpot = new ContractType(10, "FXSpot");
        values.add(FXSpot);
        for (ContractType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new ContractType[values.size()];
        values.toArray(mValues);
    }
}

