/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ContractRiskStatus {
    private static final String TAG = "ContractRiskStatus";
    @Constant(value=0)
    public static final ContractRiskStatus None;
    @Constant(value=1)
    public static final ContractRiskStatus DayTrading;
    @Constant(value=2)
    public static final ContractRiskStatus Alerting;
    @Constant(value=3)
    public static final ContractRiskStatus Liquidation;
    @Constant(value=4)
    public static final ContractRiskStatus LiquidationWaiting;
    @Constant(value=5)
    public static final ContractRiskStatus BlockExpirationLiquidation;
    @Constant(value=6)
    public static final ContractRiskStatus PriceLimitLiquidation;
    private final int value;
    private final String name;
    private static Map<Integer, ContractRiskStatus> map;
    private static ContractRiskStatus[] mValues;

    ContractRiskStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractRiskStatus get(int value) {
        ContractRiskStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ContractRiskStatus(value, Integer.toString(value));
            map.put(value, val);
            ArrayList<ContractRiskStatus> values = new ArrayList<ContractRiskStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ContractRiskStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ContractRiskStatus[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, ContractRiskStatus>();
        ArrayList<ContractRiskStatus> values = new ArrayList<ContractRiskStatus>();
        None = new ContractRiskStatus(0, "None");
        values.add(None);
        DayTrading = new ContractRiskStatus(1, "DayTrading");
        values.add(DayTrading);
        Alerting = new ContractRiskStatus(2, "Alerting");
        values.add(Alerting);
        Liquidation = new ContractRiskStatus(3, "Liquidation");
        values.add(Liquidation);
        LiquidationWaiting = new ContractRiskStatus(4, "LiquidationWaiting");
        values.add(LiquidationWaiting);
        BlockExpirationLiquidation = new ContractRiskStatus(5, "BlockExpirationLiquidation");
        values.add(BlockExpirationLiquidation);
        PriceLimitLiquidation = new ContractRiskStatus(6, "PriceLimitLiquidation");
        values.add(PriceLimitLiquidation);
        for (ContractRiskStatus t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ContractRiskStatus[values.size()];
        values.toArray(mValues);
    }
}

