/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@AsEnum
public class ContractFields {
    private static final String TAG = "ContractFields";
    @Constant(value=0)
    public static final ContractFields None;
    @Constant(value=1)
    public static final ContractFields ExchangeID;
    @Constant(value=2)
    public static final ContractFields ContractID;
    @Constant(value=4)
    public static final ContractFields Enabled;
    @Constant(value=8)
    public static final ContractFields Margin;
    @Constant(value=16)
    public static final ContractFields StrategyMargin;
    @Constant(value=32)
    public static final ContractFields CustomerFee;
    @Constant(value=64)
    public static final ContractFields MemberFee;
    @Constant(value=128)
    public static final ContractFields BlockExpiring;
    @Constant(value=256)
    public static final ContractFields BlockExpiringCanOverride;
    @Constant(value=512)
    public static final ContractFields FixedMargin;
    @Constant(value=1024)
    public static final ContractFields AutoLiquidate;
    @Constant(value=2048)
    public static final ContractFields ActiveMonths;
    private final int value;
    private static Map<Integer, ContractFields> map;
    private static ContractFields[] mValues;

    ContractFields(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractFields get(int value) {
        ContractFields val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ContractFields(value);
            map.put(value, val);
            ArrayList<ContractFields> values = new ArrayList<ContractFields>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ContractFields[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ContractFields[] values() {
        return mValues;
    }

    public String toString() {
        return "ContractFields(" + this.getValue() + ")";
    }

    public static Set<ContractFields> fromFlags(int flags) {
        HashSet<ContractFields> mktTypes = new HashSet<ContractFields>();
        for (ContractFields flag : mValues) {
            if ((flags & flag.getValue()) != flag.getValue()) continue;
            mktTypes.add(flag);
        }
        return mktTypes;
    }

    public static int toFlags(Set<ContractFields> set) {
        int flags = 0;
        for (ContractFields typ : set) {
            flags |= typ.getValue();
        }
        return flags;
    }

    static {
        map = new HashMap<Integer, ContractFields>();
        ArrayList<ContractFields> values = new ArrayList<ContractFields>();
        None = new ContractFields(0);
        values.add(None);
        ExchangeID = new ContractFields(1);
        values.add(ExchangeID);
        ContractID = new ContractFields(2);
        values.add(ContractID);
        Enabled = new ContractFields(4);
        values.add(Enabled);
        Margin = new ContractFields(8);
        values.add(Margin);
        StrategyMargin = new ContractFields(16);
        values.add(StrategyMargin);
        CustomerFee = new ContractFields(32);
        values.add(CustomerFee);
        MemberFee = new ContractFields(64);
        values.add(MemberFee);
        BlockExpiring = new ContractFields(128);
        values.add(BlockExpiring);
        BlockExpiringCanOverride = new ContractFields(256);
        values.add(BlockExpiringCanOverride);
        FixedMargin = new ContractFields(512);
        values.add(FixedMargin);
        AutoLiquidate = new ContractFields(1024);
        values.add(AutoLiquidate);
        ActiveMonths = new ContractFields(2048);
        values.add(ActiveMonths);
        for (ContractFields val : values) {
            map.put(val.getValue(), val);
        }
        mValues = new ContractFields[values.size()];
        values.toArray(mValues);
    }
}

