/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ContinuationType {
    private static final String TAG = "ContinuationType";
    @Constant(value=0)
    public static final ContinuationType Volume;
    @Constant(value=1)
    public static final ContinuationType Expiry;
    private final int value;
    private final String name;
    private final String descr_loc;
    private static Map<Integer, ContinuationType> map;
    private static Map<String, ContinuationType> names;
    private static ContinuationType[] mValues;

    private ContinuationType(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
    }

    public String name() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static ContinuationType valueOf(String name) {
        return names.get(name);
    }

    public static ContinuationType get(int value) {
        ContinuationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ContinuationType(value, Integer.toString(value), null);
            map.put(value, val);
            ArrayList<ContinuationType> values = new ArrayList<ContinuationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ContinuationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static ContinuationType[] values() {
        return mValues;
    }

    public String toString() {
        return "ContinuationType(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o instanceof ContinuationType && this.value == ((ContinuationType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, ContinuationType>();
        names = new HashMap<String, ContinuationType>();
        ArrayList<ContinuationType> values = new ArrayList<ContinuationType>();
        Volume = new ContinuationType(0, "Volume", "continuationtype_volume");
        values.add(Volume);
        Expiry = new ContinuationType(1, "Expiry", "continuationtype_expiry");
        values.add(Expiry);
        for (ContinuationType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new ContinuationType[values.size()];
        values.toArray(mValues);
    }
}

