/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class CommissionAndFees {
    private static final String TAG = "CommissionAndFees";
    @Constant(value=0)
    public static final CommissionAndFees None;
    @Constant(value=1)
    public static final CommissionAndFees Customer;
    @Constant(value=2)
    public static final CommissionAndFees Member;
    private final int value;
    private static Map<Integer, CommissionAndFees> map;
    private static CommissionAndFees[] mValues;

    CommissionAndFees(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CommissionAndFees get(int value) {
        CommissionAndFees val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new CommissionAndFees(value);
            map.put(value, val);
            ArrayList<CommissionAndFees> values = new ArrayList<CommissionAndFees>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new CommissionAndFees[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public CommissionAndFees[] values() {
        return mValues;
    }

    public String toString() {
        return "CommissionAndFees(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, CommissionAndFees>();
        ArrayList<CommissionAndFees> values = new ArrayList<CommissionAndFees>();
        None = new CommissionAndFees(0);
        values.add(None);
        Customer = new CommissionAndFees(1);
        values.add(Customer);
        Member = new CommissionAndFees(2);
        values.add(Member);
        for (CommissionAndFees t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new CommissionAndFees[values.size()];
        values.toArray(mValues);
    }
}

