/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import com.t4login.application.configuration.RequiresRole;
import com.t4login.application.configuration.UserRole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ChartType {
    private static final String TAG = "ChartTypeEn";
    @Constant(value=0)
    public static final ChartType Bar;
    @RequiresRole(value=UserRole.Standard)
    @Constant(value=1)
    public static final ChartType HeikenAshi;
    @RequiresRole(value=UserRole.NotAllowed)
    @Constant(value=2)
    public static final ChartType ThreeLineBreak;
    @RequiresRole(value=UserRole.Standard)
    @Constant(value=3)
    public static final ChartType Renko;
    @RequiresRole(value=UserRole.Standard)
    @Constant(value=4)
    public static final ChartType PointAndFigure;
    private final int value;
    private final String name;
    private final String descr_loc;
    private final String abbrDescr_loc;
    private static Map<Integer, ChartType> map;
    private static Map<String, ChartType> names;
    private static ChartType[] mValues;

    private ChartType(int value, String name, String descr_loc, String abbrDescr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
        this.abbrDescr_loc = abbrDescr_loc;
    }

    public String name() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public String getDescriptionAbbr() {
        if (this.abbrDescr_loc != null) {
            return Resource.localizeString(this.abbrDescr_loc);
        }
        return Integer.toString(this.value);
    }

    public static ChartType valueOf(String name) {
        return names.get(name);
    }

    public static ChartType get(int value) {
        ChartType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ChartType(value, Integer.toString(value), null, null);
            map.put(value, val);
            ArrayList<ChartType> values = new ArrayList<ChartType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ChartType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ChartType[] values() {
        return mValues;
    }

    public String toString() {
        return "ChartTypeEn(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ChartType>();
        names = new HashMap<String, ChartType>();
        ArrayList<ChartType> values = new ArrayList<ChartType>();
        Bar = new ChartType(0, "Bar", "charttype_bar", "charttype_bar_abbr");
        values.add(Bar);
        HeikenAshi = new ChartType(1, "HeikenAshi", "charttype_heikenashi", "charttype_heikenashi_abbr");
        values.add(HeikenAshi);
        ThreeLineBreak = new ChartType(2, "ThreeLineBreak", "charttype_threelinebreak", "charttype_threelinebreak_abbr");
        values.add(ThreeLineBreak);
        Renko = new ChartType(3, "Renko", "charttype_renko", "charttype_renko_abbr");
        values.add(Renko);
        PointAndFigure = new ChartType(4, "PointAndFigure", "charttype_pointandfigure", "charttype_pointandfigure_abbr");
        values.add(PointAndFigure);
        for (ChartType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new ChartType[values.size()];
        values.toArray(mValues);
    }
}

