/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ChartResetInterval {
    private static final String TAG = "ChartResetInterval";
    @Constant(value=0)
    public static final ChartResetInterval None;
    @Constant(value=1)
    public static final ChartResetInterval TradingDay;
    @Constant(value=2)
    public static final ChartResetInterval TradingWeek;
    @Constant(value=3)
    public static final ChartResetInterval ExpiryChange;
    private final int value;
    private final String name;
    private static Map<Integer, ChartResetInterval> map;
    private static Map<String, ChartResetInterval> names;
    private static ChartResetInterval[] mValues;

    ChartResetInterval(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartResetInterval valueOf(String name) {
        return names.get(name);
    }

    public static ChartResetInterval get(int value) {
        ChartResetInterval val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ChartResetInterval(value, Integer.toString(value));
            map.put(value, val);
            ArrayList<ChartResetInterval> values = new ArrayList<ChartResetInterval>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ChartResetInterval[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ChartResetInterval[] values() {
        return mValues;
    }

    public String toString() {
        return "ChartResetInterval(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ChartResetInterval>();
        names = new HashMap<String, ChartResetInterval>();
        ArrayList<ChartResetInterval> values = new ArrayList<ChartResetInterval>();
        None = new ChartResetInterval(0, "None");
        values.add(None);
        TradingDay = new ChartResetInterval(1, "TradingDay");
        values.add(TradingDay);
        TradingWeek = new ChartResetInterval(2, "TradingWeek");
        values.add(TradingWeek);
        ExpiryChange = new ChartResetInterval(3, "ExpiryChange");
        values.add(ExpiryChange);
        for (ChartResetInterval t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ChartResetInterval[values.size()];
        values.toArray(mValues);
    }
}

