/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ChartRequestStatus {
    private static final String TAG = "ChartRequestStatus";
    @Constant(value=0)
    public static final ChartRequestStatus Success;
    @Constant(value=1)
    public static final ChartRequestStatus Failed;
    @Constant(value=2)
    public static final ChartRequestStatus ExceedsLimits;
    @Constant(value=3)
    public static final ChartRequestStatus NoPermission;
    private final int value;
    private static Map<Integer, ChartRequestStatus> map;
    private static ChartRequestStatus[] mValues;

    ChartRequestStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartRequestStatus get(int value) {
        ChartRequestStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ChartRequestStatus(value);
            map.put(value, val);
            ArrayList<ChartRequestStatus> values = new ArrayList<ChartRequestStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ChartRequestStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ChartRequestStatus[] values() {
        return mValues;
    }

    public String toString() {
        return "ChartRequestStatus(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ChartRequestStatus>();
        ArrayList<ChartRequestStatus> values = new ArrayList<ChartRequestStatus>();
        Success = new ChartRequestStatus(0);
        values.add(Success);
        Failed = new ChartRequestStatus(1);
        values.add(Failed);
        ExceedsLimits = new ChartRequestStatus(2);
        values.add(ExceedsLimits);
        NoPermission = new ChartRequestStatus(3);
        values.add(NoPermission);
        for (ChartRequestStatus t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ChartRequestStatus[values.size()];
        values.toArray(mValues);
    }
}

