/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ChartDataRequestApplication {
    private static final String TAG = "AccountBuffer";
    @Constant(value=0)
    public static final ChartDataRequestApplication Unknown;
    @Constant(value=1)
    public static final ChartDataRequestApplication Chart;
    @Constant(value=2)
    public static final ChartDataRequestApplication MarketProfile;
    @Constant(value=3)
    public static final ChartDataRequestApplication QuoteBoard;
    @Constant(value=4)
    public static final ChartDataRequestApplication API;
    @Constant(value=5)
    public static final ChartDataRequestApplication Spreader;
    @Constant(value=6)
    public static final ChartDataRequestApplication OptionSheet;
    @Constant(value=7)
    public static final ChartDataRequestApplication OptionHistory;
    @Constant(value=8)
    public static final ChartDataRequestApplication PortfolioAnalysis;
    @Constant(value=9)
    public static final ChartDataRequestApplication MarketHistory;
    private final int value;
    private static Map<Integer, ChartDataRequestApplication> map;
    private static ChartDataRequestApplication[] mValues;

    ChartDataRequestApplication(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartDataRequestApplication get(int value) {
        ChartDataRequestApplication val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ChartDataRequestApplication(value);
            map.put(value, val);
            ArrayList<ChartDataRequestApplication> values = new ArrayList<ChartDataRequestApplication>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ChartDataRequestApplication[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ChartDataRequestApplication[] values() {
        return mValues;
    }

    public String toString() {
        return "ChartDataRequestApplication(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ChartDataRequestApplication>();
        ArrayList<ChartDataRequestApplication> values = new ArrayList<ChartDataRequestApplication>();
        Unknown = new ChartDataRequestApplication(0);
        values.add(Unknown);
        Chart = new ChartDataRequestApplication(1);
        values.add(Chart);
        MarketProfile = new ChartDataRequestApplication(2);
        values.add(MarketProfile);
        QuoteBoard = new ChartDataRequestApplication(3);
        values.add(QuoteBoard);
        API = new ChartDataRequestApplication(4);
        values.add(API);
        Spreader = new ChartDataRequestApplication(5);
        values.add(Spreader);
        OptionSheet = new ChartDataRequestApplication(6);
        values.add(OptionSheet);
        OptionHistory = new ChartDataRequestApplication(7);
        values.add(OptionHistory);
        PortfolioAnalysis = new ChartDataRequestApplication(8);
        values.add(PortfolioAnalysis);
        MarketHistory = new ChartDataRequestApplication(9);
        values.add(MarketHistory);
        for (ChartDataRequestApplication t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ChartDataRequestApplication[values.size()];
        values.toArray(mValues);
    }
}

