/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ChartDataFormat {
    private static final String TAG = "ChartDataFormat";
    @Constant(value=0)
    public static final ChartDataFormat CSV;
    @Constant(value=1)
    public static final ChartDataFormat T4C;
    @Constant(value=2)
    public static final ChartDataFormat T4Bin;
    private final int value;
    private static Map<Integer, ChartDataFormat> map;
    private static ChartDataFormat[] mValues;

    ChartDataFormat(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartDataFormat get(int value) {
        ChartDataFormat val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ChartDataFormat(value);
            map.put(value, val);
            ArrayList<ChartDataFormat> values = new ArrayList<ChartDataFormat>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ChartDataFormat[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ChartDataFormat[] values() {
        return mValues;
    }

    public String toString() {
        return "ChartDataFormat(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ChartDataFormat>();
        ArrayList<ChartDataFormat> values = new ArrayList<ChartDataFormat>();
        CSV = new ChartDataFormat(0);
        values.add(CSV);
        T4C = new ChartDataFormat(1);
        values.add(T4C);
        T4Bin = new ChartDataFormat(2);
        values.add(T4Bin);
        for (ChartDataFormat t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ChartDataFormat[values.size()];
        values.toArray(mValues);
    }
}

