/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class CategoryType {
    private static final String TAG = "CategoryType";
    @Constant(value=0)
    public static final CategoryType Unknown;
    @Constant(value=1)
    public static final CategoryType Currency;
    @Constant(value=2)
    public static final CategoryType InterestRate;
    @Constant(value=3)
    public static final CategoryType FXCurrency;
    @Constant(value=4)
    public static final CategoryType SSF;
    private final int value;
    private static Map<Integer, CategoryType> map;
    private static CategoryType[] mValues;

    CategoryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CategoryType get(int value) {
        CategoryType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new CategoryType(value);
            map.put(value, val);
            ArrayList<CategoryType> values = new ArrayList<CategoryType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new CategoryType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public CategoryType[] values() {
        return mValues;
    }

    public String toString() {
        return "CategoryType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, CategoryType>();
        ArrayList<CategoryType> values = new ArrayList<CategoryType>();
        Unknown = new CategoryType(0);
        values.add(Unknown);
        Currency = new CategoryType(1);
        values.add(Currency);
        InterestRate = new CategoryType(2);
        values.add(InterestRate);
        FXCurrency = new CategoryType(3);
        values.add(FXCurrency);
        SSF = new CategoryType(4);
        values.add(SSF);
        for (CategoryType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new CategoryType[values.size()];
        values.toArray(mValues);
    }
}

