/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public final class CashierNotificationType {
    private static final String TAG = "CashierNotificationType";
    @Constant(value=0)
    public static final CashierNotificationType DepositPending;
    @Constant(value=1)
    public static final CashierNotificationType DepoistComplete;
    @Constant(value=2)
    public static final CashierNotificationType DepositRejected;
    @Constant(value=3)
    public static final CashierNotificationType WithdrawalPending;
    @Constant(value=4)
    public static final CashierNotificationType WithdrawalComplete;
    @Constant(value=5)
    public static final CashierNotificationType WithdrawalRejected;
    private final int value;
    private final String name;
    private static final Map<Integer, CashierNotificationType> map;
    private static final Map<String, CashierNotificationType> nameMap;
    private static CashierNotificationType[] mValues;

    private CashierNotificationType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static CashierNotificationType get(int value) {
        CashierNotificationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new CashierNotificationType(value, "?" + value);
            map.put(value, val);
            ArrayList<CashierNotificationType> values = new ArrayList<CashierNotificationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new CashierNotificationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static CashierNotificationType fromName(String name) {
        return nameMap.get(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, CashierNotificationType>();
        nameMap = new HashMap<String, CashierNotificationType>();
        ArrayList<CashierNotificationType> values = new ArrayList<CashierNotificationType>();
        DepositPending = new CashierNotificationType(0, "DepositPending");
        values.add(DepositPending);
        DepoistComplete = new CashierNotificationType(1, "DepoistComplete");
        values.add(DepoistComplete);
        DepositRejected = new CashierNotificationType(2, "DepositRejected");
        values.add(DepositRejected);
        WithdrawalPending = new CashierNotificationType(3, "WithdrawalPending");
        values.add(WithdrawalPending);
        WithdrawalComplete = new CashierNotificationType(4, "WithdrawalComplete");
        values.add(WithdrawalComplete);
        WithdrawalRejected = new CashierNotificationType(5, "WithdrawalRejected");
        values.add(WithdrawalRejected);
        for (CashierNotificationType t : values) {
            map.put(t.getValue(), t);
            nameMap.put(t.name, t);
        }
        mValues = new CashierNotificationType[values.size()];
        values.toArray(mValues);
    }
}

