/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class CTI {
    private static final String TAG = "CTI";
    @Constant(value=-1)
    public static final CTI None;
    @Constant(value=0)
    public static final CTI Undefined;
    @Constant(value=1)
    public static final CTI Member;
    @Constant(value=2)
    public static final CTI Proprietary;
    @Constant(value=3)
    public static final CTI BrokerMember;
    @Constant(value=4)
    public static final CTI BrokerCustomer;
    private final int value;
    private final String descr_loc;
    private static Map<Integer, CTI> map;
    private static CTI[] mValues;

    CTI(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static CTI get(int value) {
        CTI val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new CTI(value, null);
            map.put(value, val);
            ArrayList<CTI> values = new ArrayList<CTI>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new CTI[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public String toString() {
        return "CTI(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, CTI>();
        ArrayList<CTI> values = new ArrayList<CTI>();
        None = new CTI(-1, "cti_none");
        values.add(None);
        Undefined = new CTI(0, "cti_undefined");
        values.add(Undefined);
        Member = new CTI(1, "cti_member");
        values.add(Member);
        Proprietary = new CTI(2, "cti_proprietary");
        values.add(Proprietary);
        BrokerMember = new CTI(3, "cti_brokermember");
        values.add(BrokerMember);
        BrokerCustomer = new CTI(4, "cti_brokercustomer");
        values.add(BrokerCustomer);
        for (CTI t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new CTI[values.size()];
        values.toArray(mValues);
    }
}

