/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class BuySell
implements Serializable {
    private static final String TAG = "BuySell";
    @Constant(value=0)
    public static final BuySell Undefined;
    @Constant(value=1)
    public static final BuySell Buy;
    @Constant(value=-1)
    public static final BuySell Sell;
    private final int value;
    private final String name;
    private final String descr_loc;
    private static Map<Integer, BuySell> map;
    private static BuySell[] mValues;

    BuySell(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static BuySell get(int value) {
        BuySell val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new BuySell(value, String.format("%d", value), null);
            map.put(value, val);
            ArrayList<BuySell> values = new ArrayList<BuySell>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new BuySell[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static BuySell[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof BuySell && this.value == ((BuySell)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, BuySell>();
        ArrayList<BuySell> values = new ArrayList<BuySell>();
        Undefined = new BuySell(0, "Undefined", "buysell_undefined");
        values.add(Undefined);
        Buy = new BuySell(1, "Buy", "buysell_buy");
        values.add(Buy);
        Sell = new BuySell(-1, "Sell", "buysell_sell");
        values.add(Sell);
        for (BuySell t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new BuySell[values.size()];
        values.toArray(mValues);
    }
}

