/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class BillingFee {
    private static final String TAG = "BillingFee";
    @Constant(value=0)
    public static final BillingFee Undefined;
    @Constant(value=1)
    public static final BillingFee Customer;
    @Constant(value=2)
    public static final BillingFee EquityMember;
    @Constant(value=3)
    public static final BillingFee Firm106HJ;
    @Constant(value=4)
    public static final BillingFee Lessee106FEmployee;
    @Constant(value=5)
    public static final BillingFee CBOEMember;
    private final int value;
    private static Map<Integer, BillingFee> map;
    private static BillingFee[] mValues;

    BillingFee(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BillingFee get(int value) {
        BillingFee val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new BillingFee(value);
            map.put(value, val);
            ArrayList<BillingFee> values = new ArrayList<BillingFee>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new BillingFee[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public BillingFee[] values() {
        return mValues;
    }

    public String toString() {
        return "BillingFee(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, BillingFee>();
        ArrayList<BillingFee> values = new ArrayList<BillingFee>();
        Undefined = new BillingFee(0);
        values.add(Undefined);
        Customer = new BillingFee(1);
        values.add(Customer);
        EquityMember = new BillingFee(2);
        values.add(EquityMember);
        Firm106HJ = new BillingFee(3);
        values.add(Firm106HJ);
        Lessee106FEmployee = new BillingFee(4);
        values.add(Lessee106FEmployee);
        CBOEMember = new BillingFee(5);
        values.add(CBOEMember);
        for (BillingFee t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new BillingFee[values.size()];
        values.toArray(mValues);
    }
}

