/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class BidOffer
implements Serializable {
    private static final String TAG = "BidOffer";
    @Constant(value=0)
    public static final BidOffer Undefined;
    @Constant(value=1)
    public static final BidOffer Bid;
    @Constant(value=-1)
    public static final BidOffer Offer;
    private final int value;
    private final String descr_loc;
    private static Map<Integer, BidOffer> map;
    private static BidOffer[] mValues;

    private BidOffer(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static BidOffer get(int value) {
        BidOffer val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new BidOffer(value, null);
            map.put(value, val);
            ArrayList<BidOffer> values = new ArrayList<BidOffer>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new BidOffer[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static BidOffer[] values() {
        return mValues;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof BidOffer && this.value == ((BidOffer)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, BidOffer>();
        ArrayList<BidOffer> values = new ArrayList<BidOffer>();
        Undefined = new BidOffer(0, "bidoffer_undefined");
        values.add(Undefined);
        Bid = new BidOffer(1, "bidoffer_bid");
        values.add(Bid);
        Offer = new BidOffer(-1, "bidoffer_offer");
        values.add(Offer);
        for (BidOffer t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new BidOffer[values.size()];
        values.toArray(mValues);
    }
}

