/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class BarIntervalBreak {
    private static final String TAG = "BarIntervalBreak";
    @Constant(value=0)
    public static final BarIntervalBreak Tick;
    @Constant(value=1)
    public static final BarIntervalBreak TickRange;
    @Constant(value=2)
    public static final BarIntervalBreak Volume;
    @Constant(value=3)
    public static final BarIntervalBreak Second;
    @Constant(value=4)
    public static final BarIntervalBreak Minute;
    @Constant(value=5)
    public static final BarIntervalBreak Hour;
    @Constant(value=6)
    public static final BarIntervalBreak Day;
    @Constant(value=7)
    public static final BarIntervalBreak Week;
    private final int value;
    private final String name;
    private static Map<Integer, BarIntervalBreak> map;
    private static Map<String, BarIntervalBreak> names;
    private static BarIntervalBreak[] mValues;

    BarIntervalBreak(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static BarIntervalBreak valueOf(String name) {
        return names.get(name);
    }

    public static BarIntervalBreak get(int value) {
        BarIntervalBreak val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new BarIntervalBreak(value, Integer.toString(value));
            map.put(value, val);
            ArrayList<BarIntervalBreak> values = new ArrayList<BarIntervalBreak>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new BarIntervalBreak[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public BarIntervalBreak[] values() {
        return mValues;
    }

    public String toString() {
        return "BarIntervalBreak(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, BarIntervalBreak>();
        names = new HashMap<String, BarIntervalBreak>();
        ArrayList<BarIntervalBreak> values = new ArrayList<BarIntervalBreak>();
        Tick = new BarIntervalBreak(0, "Tick");
        values.add(Tick);
        TickRange = new BarIntervalBreak(1, "TickRange");
        values.add(TickRange);
        Volume = new BarIntervalBreak(2, "Volume");
        values.add(Volume);
        Second = new BarIntervalBreak(3, "Second");
        values.add(Second);
        Minute = new BarIntervalBreak(4, "Minute");
        values.add(Minute);
        Hour = new BarIntervalBreak(5, "Hour");
        values.add(Hour);
        Day = new BarIntervalBreak(6, "Day");
        values.add(Day);
        Week = new BarIntervalBreak(7, "Week");
        values.add(Week);
        for (BarIntervalBreak t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new BarIntervalBreak[values.size()];
        values.toArray(mValues);
    }
}

