/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class BandwidthType {
    private static final String TAG = "BandwidthType";
    @Constant(value=0)
    public static final BandwidthType Normal;
    @Constant(value=1)
    public static final BandwidthType Reduced;
    private final int value;
    private final String descr_loc;
    private static Map<Integer, BandwidthType> map;
    private static BandwidthType[] mValues;

    BandwidthType(int value, String descr_loc) {
        this.value = value;
        this.descr_loc = descr_loc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static BandwidthType get(int value) {
        BandwidthType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new BandwidthType(value, null);
            map.put(value, val);
            ArrayList<BandwidthType> values = new ArrayList<BandwidthType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new BandwidthType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public BandwidthType[] values() {
        return mValues;
    }

    public String toString() {
        return "BandwidthType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, BandwidthType>();
        ArrayList<BandwidthType> values = new ArrayList<BandwidthType>();
        Normal = new BandwidthType(0, "bandwidthtype_normal");
        values.add(Normal);
        Reduced = new BandwidthType(1, "bandwidthtype_reduced");
        values.add(Reduced);
        for (BandwidthType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new BandwidthType[values.size()];
        values.toArray(mValues);
    }
}

