/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AvgPriceIndicatorType {
    private static final String TAG = "AvgPriceIndicatorType";
    @Constant(value=0)
    public static final AvgPriceIndicatorType None;
    @Constant(value=1)
    public static final AvgPriceIndicatorType AveragePriceGroup;
    @Constant(value=2)
    public static final AvgPriceIndicatorType NotionalValueAverage;
    private final int value;
    private static Map<Integer, AvgPriceIndicatorType> map;
    private static AvgPriceIndicatorType[] mValues;

    AvgPriceIndicatorType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AvgPriceIndicatorType get(int value) {
        AvgPriceIndicatorType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AvgPriceIndicatorType(value);
            map.put(value, val);
            ArrayList<AvgPriceIndicatorType> values = new ArrayList<AvgPriceIndicatorType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AvgPriceIndicatorType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AvgPriceIndicatorType[] values() {
        return mValues;
    }

    public String toString() {
        return "AvgPriceIndicatorType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AvgPriceIndicatorType>();
        ArrayList<AvgPriceIndicatorType> values = new ArrayList<AvgPriceIndicatorType>();
        None = new AvgPriceIndicatorType(0);
        values.add(None);
        AveragePriceGroup = new AvgPriceIndicatorType(1);
        values.add(AveragePriceGroup);
        NotionalValueAverage = new AvgPriceIndicatorType(2);
        values.add(NotionalValueAverage);
        for (AvgPriceIndicatorType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AvgPriceIndicatorType[values.size()];
        values.toArray(mValues);
    }
}

