/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AutoPullType {
    private static final String TAG = "AutoPullType";
    @Constant(value=0)
    public static final AutoPullType None;
    @Constant(value=1)
    public static final AutoPullType Account;
    @Constant(value=2)
    public static final AutoPullType User;
    private final int value;
    private static Map<Integer, AutoPullType> map;
    private static AutoPullType[] mValues;

    AutoPullType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AutoPullType get(int value) {
        AutoPullType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AutoPullType(value);
            map.put(value, val);
            ArrayList<AutoPullType> values = new ArrayList<AutoPullType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AutoPullType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AutoPullType[] values() {
        return mValues;
    }

    public String toString() {
        return "AutoPullType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AutoPullType>();
        ArrayList<AutoPullType> values = new ArrayList<AutoPullType>();
        None = new AutoPullType(0);
        values.add(None);
        Account = new AutoPullType(1);
        values.add(Account);
        User = new AutoPullType(2);
        values.add(User);
        for (AutoPullType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AutoPullType[values.size()];
        values.toArray(mValues);
    }
}

