/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ApplicationType {
    private static final String TAG = "ApplicationType";
    @Constant(value=0)
    public static final ApplicationType Manual;
    @Constant(value=1)
    public static final ApplicationType ATS;
    @Constant(value=2)
    public static final ApplicationType Professional;
    @Constant(value=3)
    public static final ApplicationType NonProfessional;
    @Constant(value=4)
    public static final ApplicationType Desk;
    @Constant(value=5)
    public static final ApplicationType Wallboard;
    @Constant(value=6)
    public static final ApplicationType SubVendor;
    @Constant(value=7)
    public static final ApplicationType ATSDisplay;
    @Constant(value=8)
    public static final ApplicationType FinancialProfessional;
    private final int value;
    private static Map<Integer, ApplicationType> map;
    private static ApplicationType[] mValues;

    private ApplicationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ApplicationType get(int value) {
        ApplicationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ApplicationType(value);
            map.put(value, val);
            ArrayList<ApplicationType> values = new ArrayList<ApplicationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ApplicationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ApplicationType[] values() {
        return mValues;
    }

    public String toString() {
        return "ApplicationType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, ApplicationType>();
        ArrayList<ApplicationType> values = new ArrayList<ApplicationType>();
        Manual = new ApplicationType(0);
        values.add(Manual);
        ATS = new ApplicationType(1);
        values.add(ATS);
        Professional = new ApplicationType(2);
        values.add(Professional);
        NonProfessional = new ApplicationType(3);
        values.add(NonProfessional);
        Desk = new ApplicationType(4);
        values.add(Desk);
        Wallboard = new ApplicationType(5);
        values.add(Wallboard);
        SubVendor = new ApplicationType(6);
        values.add(SubVendor);
        ATSDisplay = new ApplicationType(7);
        values.add(ATSDisplay);
        FinancialProfessional = new ApplicationType(8);
        values.add(FinancialProfessional);
        for (ApplicationType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ApplicationType[values.size()];
        values.toArray(mValues);
    }
}

