/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.APIName;
import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@APIName(value="Application")
@AsEnum
public class AppSource {
    private static final String TAG = "AppSource";
    @Constant(value=-1)
    public static final AppSource None;
    @Constant(value=0)
    public static final AppSource API;
    @Constant(value=1)
    public static final AppSource UserHandler;
    @Constant(value=2)
    public static final AppSource AccountHandler;
    @Constant(value=3)
    public static final AppSource ExchangeHandler;
    @Constant(value=4)
    public static final AppSource RemoteDataHandler;
    @Constant(value=5)
    public static final AppSource AccountLoader;
    @Constant(value=6)
    public static final AppSource DataImportHandler;
    @Constant(value=7)
    public static final AppSource LicenseHandler;
    @Constant(value=8)
    public static final AppSource ExchangeMaster;
    @Constant(value=9)
    public static final AppSource NewsHandler;
    @Constant(value=10)
    public static final AppSource Website;
    @Constant(value=11)
    public static final AppSource SelfReg;
    @Constant(value=12)
    public static final AppSource LetItTrade;
    @Constant(value=13)
    public static final AppSource Simulator;
    @Constant(value=14)
    public static final AppSource ChartServer;
    @Constant(value=15)
    public static final AppSource Billing;
    @Constant(value=16)
    public static final AppSource DataExport;
    @Constant(value=17)
    public static final AppSource SkewHandler;
    @Constant(value=18)
    public static final AppSource DataExtract;
    @Constant(value=19)
    public static final AppSource AutomationHandler;
    @Constant(value=20)
    public static final AppSource WebSvc;
    private final int value;
    private static Map<Integer, AppSource> map;
    private static AppSource[] mValues;

    AppSource(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AppSource get(int value) {
        AppSource val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AppSource(value);
            map.put(value, val);
            ArrayList<AppSource> values = new ArrayList<AppSource>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AppSource[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AppSource[] values() {
        return mValues;
    }

    public String toString() {
        return "AppSource(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AppSource>();
        ArrayList<AppSource> values = new ArrayList<AppSource>();
        None = new AppSource(-1);
        values.add(None);
        API = new AppSource(0);
        values.add(API);
        UserHandler = new AppSource(1);
        values.add(UserHandler);
        AccountHandler = new AppSource(2);
        values.add(AccountHandler);
        ExchangeHandler = new AppSource(3);
        values.add(ExchangeHandler);
        RemoteDataHandler = new AppSource(4);
        values.add(RemoteDataHandler);
        AccountLoader = new AppSource(5);
        values.add(AccountLoader);
        DataImportHandler = new AppSource(6);
        values.add(DataImportHandler);
        LicenseHandler = new AppSource(7);
        values.add(LicenseHandler);
        ExchangeMaster = new AppSource(8);
        values.add(ExchangeMaster);
        NewsHandler = new AppSource(9);
        values.add(NewsHandler);
        Website = new AppSource(10);
        values.add(Website);
        SelfReg = new AppSource(11);
        values.add(SelfReg);
        LetItTrade = new AppSource(12);
        values.add(LetItTrade);
        Simulator = new AppSource(13);
        values.add(Simulator);
        ChartServer = new AppSource(14);
        values.add(ChartServer);
        Billing = new AppSource(15);
        values.add(Billing);
        DataExport = new AppSource(16);
        values.add(DataExport);
        SkewHandler = new AppSource(17);
        values.add(SkewHandler);
        DataExtract = new AppSource(18);
        values.add(DataExtract);
        AutomationHandler = new AppSource(19);
        values.add(AutomationHandler);
        WebSvc = new AppSource(20);
        values.add(WebSvc);
        for (AppSource t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AppSource[values.size()];
        values.toArray(mValues);
    }
}

