/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AlertActionType
implements Serializable {
    private static final String TAG = "AlertActionType";
    @Constant(value=0)
    public static final AlertActionType Notification;
    @Constant(value=1)
    public static final AlertActionType Flash;
    @Constant(value=2)
    public static final AlertActionType Email;
    @Constant(value=3)
    public static final AlertActionType TextSMS;
    private final int value;
    private final String name;
    private final String title_loc;
    private final String descr_loc;
    private final String ico_res;
    private static Map<Integer, AlertActionType> map;
    private static Map<String, AlertActionType> names;
    private static AlertActionType[] mValues;

    AlertActionType(int value, String name, String title_loc, String descr_loc, String ico_res) {
        this.value = value;
        this.name = name;
        this.title_loc = title_loc;
        this.descr_loc = descr_loc;
        this.ico_res = ico_res;
    }

    public String name() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        if (this.title_loc != null) {
            return Resource.localizeString(this.title_loc);
        }
        return this.title_loc;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public static AlertActionType valueOf(String name) {
        return names.get(name);
    }

    public String getIconResID() {
        return this.ico_res;
    }

    public static AlertActionType get(int value) {
        AlertActionType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AlertActionType(value, Integer.toString(value), null, null, null);
            map.put(value, val);
            ArrayList<AlertActionType> values = new ArrayList<AlertActionType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AlertActionType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static AlertActionType[] values() {
        return mValues;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof AlertActionType && this.value == ((AlertActionType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, AlertActionType>();
        names = new HashMap<String, AlertActionType>();
        ArrayList<AlertActionType> values = new ArrayList<AlertActionType>();
        Notification = new AlertActionType(0, "Notification", "alertaction_notification", "alertaction_notification_descr", "ic_tap_and_play_gray_24dp");
        values.add(Notification);
        Flash = new AlertActionType(1, "Flash", "alertaction_flash", "alertaction_flash_descr", "ic_desktop_windows_gray_24dp");
        values.add(Flash);
        Email = new AlertActionType(2, "Email", "alertaction_email", "alertaction_email_descr", "ic_email_gray_24dp");
        values.add(Email);
        TextSMS = new AlertActionType(3, "TextSMS", "alertaction_sms", "alertaction_sms_descr", "ic_textsms_gray_24dp");
        values.add(TextSMS);
        for (AlertActionType t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new AlertActionType[values.size()];
        values.toArray(mValues);
    }
}

