/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class ActivationType
implements Serializable {
    private static final String TAG = "ActivationType";
    @Constant(value=-1)
    public static final ActivationType Undefined;
    @Constant(value=0)
    public static final ActivationType Immediate;
    @Constant(value=1)
    public static final ActivationType Hold;
    @Constant(value=2)
    public static final ActivationType Triggered;
    @Constant(value=3)
    public static final ActivationType AtOrAfterTime;
    @Constant(value=4)
    public static final ActivationType AtOrAboveTradeTicks;
    @Constant(value=5)
    public static final ActivationType AtOrBelowTradeTicks;
    @Constant(value=6)
    public static final ActivationType OnMarketMode;
    @Constant(value=7)
    public static final ActivationType TriggeredAtOrAfterTime;
    @Constant(value=8)
    public static final ActivationType TriggeredAtOrAboveTradeTicks;
    @Constant(value=9)
    public static final ActivationType TriggeredAtOrBelowTradeTicks;
    @Constant(value=10)
    public static final ActivationType TriggeredOnMarketMode;
    @Constant(value=11)
    public static final ActivationType Queue;
    @Constant(value=12)
    public static final ActivationType TriggeredQueue;
    @Constant(value=13)
    public static final ActivationType PitFilledQueue;
    @Constant(value=14)
    public static final ActivationType AtOrAboveTicks;
    @Constant(value=15)
    public static final ActivationType AtOrBelowTicks;
    @Constant(value=16)
    public static final ActivationType TriggeredAtOrAboveTicks;
    @Constant(value=17)
    public static final ActivationType TriggeredAtOrBelowTicks;
    @Constant(value=18)
    public static final ActivationType MarketOnClose;
    private final int value;
    private static Map<Integer, ActivationType> map;
    private static ActivationType[] mValues;

    private ActivationType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ActivationType get(int value) {
        ActivationType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new ActivationType(value);
            map.put(value, val);
            ArrayList<ActivationType> values = new ArrayList<ActivationType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new ActivationType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public ActivationType[] values() {
        return mValues;
    }

    public String toString() {
        return "ActivationType(" + this.getValue() + ")";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ActivationType && this.value == ((ActivationType)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, ActivationType>();
        ArrayList<ActivationType> values = new ArrayList<ActivationType>();
        Undefined = new ActivationType(-1);
        values.add(Undefined);
        Immediate = new ActivationType(0);
        values.add(Immediate);
        Hold = new ActivationType(1);
        values.add(Hold);
        Triggered = new ActivationType(2);
        values.add(Triggered);
        AtOrAfterTime = new ActivationType(3);
        values.add(AtOrAfterTime);
        AtOrAboveTradeTicks = new ActivationType(4);
        values.add(AtOrAboveTradeTicks);
        AtOrBelowTradeTicks = new ActivationType(5);
        values.add(AtOrBelowTradeTicks);
        OnMarketMode = new ActivationType(6);
        values.add(OnMarketMode);
        TriggeredAtOrAfterTime = new ActivationType(7);
        values.add(TriggeredAtOrAfterTime);
        TriggeredAtOrAboveTradeTicks = new ActivationType(8);
        values.add(TriggeredAtOrAboveTradeTicks);
        TriggeredAtOrBelowTradeTicks = new ActivationType(9);
        values.add(TriggeredAtOrBelowTradeTicks);
        TriggeredOnMarketMode = new ActivationType(10);
        values.add(TriggeredOnMarketMode);
        Queue = new ActivationType(11);
        values.add(Queue);
        TriggeredQueue = new ActivationType(12);
        values.add(TriggeredQueue);
        PitFilledQueue = new ActivationType(13);
        values.add(PitFilledQueue);
        AtOrAboveTicks = new ActivationType(14);
        values.add(AtOrAboveTicks);
        AtOrBelowTicks = new ActivationType(15);
        values.add(AtOrBelowTicks);
        TriggeredAtOrAboveTicks = new ActivationType(16);
        values.add(TriggeredAtOrAboveTicks);
        TriggeredAtOrBelowTicks = new ActivationType(17);
        values.add(TriggeredAtOrBelowTicks);
        MarketOnClose = new ActivationType(18);
        values.add(MarketOnClose);
        for (ActivationType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new ActivationType[values.size()];
        values.toArray(mValues);
    }
}

