/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountStatus {
    private static final String TAG = "AccountStatus";
    @Constant(value=0)
    public static final AccountStatus Unknown;
    @Constant(value=1)
    public static final AccountStatus Blocked;
    @Constant(value=2)
    public static final AccountStatus OK;
    @Constant(value=3)
    public static final AccountStatus Unrestricted;
    @Constant(value=4)
    public static final AccountStatus Deleted;
    @Constant(value=5)
    public static final AccountStatus Disabled;
    @Constant(value=6)
    public static final AccountStatus OutsideActiveTime;
    @Constant(value=7)
    public static final AccountStatus NotAccessible;
    @Constant(value=8)
    public static final AccountStatus PitTradesOnly;
    @Constant(value=9)
    public static final AccountStatus LossLimitExceeded;
    private final int value;
    private final String name;
    private static Map<Integer, AccountStatus> map;
    private static AccountStatus[] mValues;

    AccountStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountStatus get(int value) {
        AccountStatus val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AccountStatus(value, Integer.toString(value));
            map.put(value, val);
            ArrayList<AccountStatus> values = new ArrayList<AccountStatus>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountStatus[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AccountStatus[] values() {
        return mValues;
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, AccountStatus>();
        ArrayList<AccountStatus> values = new ArrayList<AccountStatus>();
        Unknown = new AccountStatus(0, "Unknown");
        values.add(Unknown);
        Blocked = new AccountStatus(1, "Blocked");
        values.add(Blocked);
        OK = new AccountStatus(2, "OK");
        values.add(OK);
        Unrestricted = new AccountStatus(3, "Unrestricted");
        values.add(Unrestricted);
        Deleted = new AccountStatus(4, "Deleted");
        values.add(Deleted);
        Disabled = new AccountStatus(5, "Disabled");
        values.add(Disabled);
        OutsideActiveTime = new AccountStatus(6, "OutsideActiveTime");
        values.add(OutsideActiveTime);
        NotAccessible = new AccountStatus(7, "NotAccessible");
        values.add(NotAccessible);
        PitTradesOnly = new AccountStatus(8, "PitTradesOnly");
        values.add(PitTradesOnly);
        LossLimitExceeded = new AccountStatus(9, "LossLimitExceeded");
        values.add(LossLimitExceeded);
        for (AccountStatus t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AccountStatus[values.size()];
        values.toArray(mValues);
    }
}

