/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountMode {
    private static final String TAG = "AccountMode";
    @Constant(value=-1)
    public static final AccountMode Unknown;
    @Constant(value=0)
    public static final AccountMode ByMarket;
    @Constant(value=1)
    public static final AccountMode ByContract;
    @Constant(value=2)
    public static final AccountMode ByAccount;
    @Constant(value=3)
    public static final AccountMode ByAccountDay;
    @Constant(value=4)
    public static final AccountMode ByPortfolio;
    @Constant(value=5)
    public static final AccountMode T500;
    @Constant(value=6)
    public static final AccountMode T500Demo;
    private final int value;
    private static final Map<Integer, AccountMode> map;
    private static AccountMode[] mValues;

    AccountMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountMode get(int value) {
        AccountMode val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + value + " created and added without name.");
            val = new AccountMode(value);
            map.put(value, val);
            ArrayList<AccountMode> values = new ArrayList<AccountMode>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountMode[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AccountMode[] values() {
        return mValues;
    }

    public String toString() {
        return "AccountMode(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AccountMode>();
        ArrayList<AccountMode> values = new ArrayList<AccountMode>();
        Unknown = new AccountMode(-1);
        values.add(Unknown);
        ByMarket = new AccountMode(0);
        values.add(ByMarket);
        ByContract = new AccountMode(1);
        values.add(ByContract);
        ByAccount = new AccountMode(2);
        values.add(ByAccount);
        ByAccountDay = new AccountMode(3);
        values.add(ByAccountDay);
        ByPortfolio = new AccountMode(4);
        values.add(ByPortfolio);
        T500 = new AccountMode(5);
        values.add(T500);
        T500Demo = new AccountMode(6);
        values.add(T500Demo);
        for (AccountMode t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AccountMode[values.size()];
        values.toArray(mValues);
    }
}

