/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountMarginType {
    private static final String TAG = "AccountMarginType";
    @Constant(value=0)
    public static final AccountMarginType Spec;
    @Constant(value=1)
    public static final AccountMarginType HedgeOrMember;
    @Constant(value=2)
    public static final AccountMarginType Member;
    private final int value;
    private static Map<Integer, AccountMarginType> map;
    private static AccountMarginType[] mValues;

    AccountMarginType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountMarginType get(int value) {
        AccountMarginType val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AccountMarginType(value);
            map.put(value, val);
            ArrayList<AccountMarginType> values = new ArrayList<AccountMarginType>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountMarginType[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AccountMarginType[] values() {
        return mValues;
    }

    public String toString() {
        return "AccountMarginType(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AccountMarginType>();
        ArrayList<AccountMarginType> values = new ArrayList<AccountMarginType>();
        Spec = new AccountMarginType(0);
        values.add(Spec);
        HedgeOrMember = new AccountMarginType(1);
        values.add(HedgeOrMember);
        Member = new AccountMarginType(2);
        values.add(Member);
        for (AccountMarginType t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AccountMarginType[values.size()];
        values.toArray(mValues);
    }
}

