/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountEnabled {
    private static final String TAG = AccountEnabled.class.getName();
    @Constant(value=0)
    public static final AccountEnabled Disabled;
    @Constant(value=1)
    public static final AccountEnabled Enabled;
    @Constant(value=2)
    public static final AccountEnabled BackOfficeOnly;
    @Constant(value=3)
    public static final AccountEnabled PitTradeOnly;
    private final int value;
    private static Map<Integer, AccountEnabled> map;
    private static AccountEnabled[] mValues;

    AccountEnabled(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountEnabled get(int value) {
        AccountEnabled val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AccountEnabled(value);
            map.put(value, val);
            ArrayList<AccountEnabled> values = new ArrayList<AccountEnabled>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountEnabled[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AccountEnabled[] values() {
        return mValues;
    }

    public String toString() {
        return "AccountEnabled(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AccountEnabled>();
        ArrayList<AccountEnabled> values = new ArrayList<AccountEnabled>();
        Disabled = new AccountEnabled(0);
        values.add(Disabled);
        Enabled = new AccountEnabled(1);
        values.add(Enabled);
        BackOfficeOnly = new AccountEnabled(2);
        values.add(BackOfficeOnly);
        PitTradeOnly = new AccountEnabled(3);
        values.add(PitTradeOnly);
        for (AccountEnabled t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AccountEnabled[values.size()];
        values.toArray(mValues);
    }
}

