/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import com.t4login.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountCode {
    @Constant(value=0)
    public static final AccountCode Undefined;
    @Constant(value=1)
    public static final AccountCode None;
    @Constant(value=2)
    public static final AccountCode GiveUpToSingleFirm;
    @Constant(value=3)
    public static final AccountCode GiveUpToMultipleFirms;
    @Constant(value=4)
    public static final AccountCode MarketMaker;
    @Constant(value=5)
    public static final AccountCode AgentA1;
    @Constant(value=6)
    public static final AccountCode GiveUpG1;
    @Constant(value=7)
    public static final AccountCode GiveUpG2;
    @Constant(value=8)
    public static final AccountCode MarketMakerM1;
    @Constant(value=9)
    public static final AccountCode MarketMakerM2;
    @Constant(value=10)
    public static final AccountCode ProprietaryP1;
    @Constant(value=11)
    public static final AccountCode ProprietaryP2;
    @Constant(value=12)
    public static final AccountCode Segregated;
    @Constant(value=13)
    public static final AccountCode NonSegregated;
    @Constant(value=14)
    public static final AccountCode House;
    @Constant(value=15)
    public static final AccountCode Local;
    @Constant(value=16)
    public static final AccountCode Default;
    @Constant(value=17)
    public static final AccountCode Allocated;
    @Constant(value=18)
    public static final AccountCode Split;
    @Constant(value=19)
    public static final AccountCode Unassigned;
    @Constant(value=20)
    public static final AccountCode GasAssociate;
    @Constant(value=21)
    public static final AccountCode Customer;
    @Constant(value=22)
    public static final AccountCode USCustomerFutures;
    @Constant(value=23)
    public static final AccountCode USCustomerSwaps;
    @Constant(value=24)
    public static final AccountCode USCustomerFBOT;
    @Constant(value=25)
    public static final AccountCode Firm;
    @Constant(value=26)
    public static final AccountCode MemberCustomerSegregatedAccount;
    @Constant(value=27)
    public static final AccountCode MemberHouseAccount;
    @Constant(value=28)
    public static final AccountCode MemberSIPCProtectedAccount;
    @Constant(value=29)
    public static final AccountCode UserProxyForTraderCustomerSegregatedAccount;
    @Constant(value=30)
    public static final AccountCode UserProxyForTraderHouseAccount;
    @Constant(value=31)
    public static final AccountCode UserProxyForTraderSIPCProtectedAccount;
    @Constant(value=32)
    public static final AccountCode NonMemberHouseAccount;
    @Constant(value=33)
    public static final AccountCode NonMemberSIPCProtectedAccount;
    @Constant(value=34)
    public static final AccountCode CustomerFloorBrokerWorkstation;
    @Constant(value=35)
    public static final AccountCode AgentA2;
    @Constant(value=36)
    public static final AccountCode AgentA3;
    @Constant(value=37)
    public static final AccountCode AgentA4;
    @Constant(value=38)
    public static final AccountCode AgentA5;
    @Constant(value=39)
    public static final AccountCode AgentA6;
    @Constant(value=40)
    public static final AccountCode AgentA7;
    @Constant(value=41)
    public static final AccountCode AgentA8;
    @Constant(value=42)
    public static final AccountCode AgentA9;
    @Constant(value=43)
    public static final AccountCode ClientSegregatedE;
    @Constant(value=44)
    public static final AccountCode ClientSegregatedK;
    @Constant(value=45)
    public static final AccountCode ClientSegregatedR;
    @Constant(value=46)
    public static final AccountCode SegregatedT;
    @Constant(value=47)
    public static final AccountCode IndirectClearingGrossISOC_CASS;
    @Constant(value=48)
    public static final AccountCode IndirectClearingGrossISOC_TTFCA;
    @Constant(value=49)
    public static final AccountCode IndirectClearingGrossCASS;
    @Constant(value=50)
    public static final AccountCode IndirectClearingGrossTTFCA;
    @Constant(value=51)
    public static final AccountCode IndirectClearingNetCASS;
    @Constant(value=52)
    public static final AccountCode IndirectClearingNetsTTFCA;
    @Constant(value=53)
    public static final AccountCode RO;
    @Constant(value=54)
    public static final AccountCode LiquidityProvider;
    @Constant(value=55)
    public static final AccountCode RelatedParty;
    @Constant(value=56)
    public static final AccountCode StructuredProductMarketMaker;
    @Constant(value=57)
    public static final AccountCode OmegaClient;
    @Constant(value=58)
    public static final AccountCode CeresClient;
    private static final String TAG = "AccountCode";
    private static Map<Integer, AccountCode> map;
    private static Map<String, AccountCode> names;
    private static AccountCode[] mValues;
    private final int value;
    private final String name;
    private final String descr_loc;

    AccountCode(int value, String name, String descr_loc) {
        this.value = value;
        this.name = name;
        this.descr_loc = descr_loc;
    }

    public static AccountCode get(int value) {
        AccountCode val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AccountCode(value, Integer.toString(value), null);
            map.put(value, val);
            ArrayList<AccountCode> values = new ArrayList<AccountCode>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountCode[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public static AccountCode valueOf(String name) {
        return names.get(name);
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        if (this.descr_loc != null) {
            return Resource.localizeString(this.descr_loc);
        }
        return Integer.toString(this.value);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap<Integer, AccountCode>();
        names = new HashMap<String, AccountCode>();
        ArrayList<AccountCode> values = new ArrayList<AccountCode>();
        Undefined = new AccountCode(0, "Undefined", "accountcode_undefined");
        values.add(Undefined);
        None = new AccountCode(1, "None", "accountcode_none");
        values.add(None);
        GiveUpToSingleFirm = new AccountCode(2, "GiveUpToSingleFirm", "accountcode_giveuptosinglefirm");
        values.add(GiveUpToSingleFirm);
        GiveUpToMultipleFirms = new AccountCode(3, "GiveUpToMultipleFirms", "accountcode_giveuptomultiplefirms");
        values.add(GiveUpToMultipleFirms);
        MarketMaker = new AccountCode(4, "MarketMaker", "accountcode_marketmaker");
        values.add(MarketMaker);
        AgentA1 = new AccountCode(5, "AgentA1", "accountcode_agenta1");
        values.add(AgentA1);
        GiveUpG1 = new AccountCode(6, "GiveUpG1", "accountcode_giveupg1");
        values.add(GiveUpG1);
        GiveUpG2 = new AccountCode(7, "GiveUpG2", "accountcode_giveupg2");
        values.add(GiveUpG2);
        MarketMakerM1 = new AccountCode(8, "MarketMakerM1", "accountcode_marketmakerm1");
        values.add(MarketMakerM1);
        MarketMakerM2 = new AccountCode(9, "MarketMakerM2", "accountcode_marketmakerm2");
        values.add(MarketMakerM2);
        ProprietaryP1 = new AccountCode(10, "ProprietaryP1", "accountcode_proprietaryp1");
        values.add(ProprietaryP1);
        ProprietaryP2 = new AccountCode(11, "ProprietaryP2", "accountcode_proprietaryp2");
        values.add(ProprietaryP2);
        Segregated = new AccountCode(12, "Segregated", "accountcode_segregated");
        values.add(Segregated);
        NonSegregated = new AccountCode(13, "NonSegregated", "accountcode_nonsegregated");
        values.add(NonSegregated);
        House = new AccountCode(14, "House", "accountcode_house");
        values.add(House);
        Local = new AccountCode(15, "Local", "accountcode_local");
        values.add(Local);
        Default = new AccountCode(16, "Default", "accountcode_default");
        values.add(Default);
        Allocated = new AccountCode(17, "Allocated", "accountcode_allocated");
        values.add(Allocated);
        Split = new AccountCode(18, "Split", "accountcode_split");
        values.add(Split);
        Unassigned = new AccountCode(19, "Unassigned", "accountcode_unassigned");
        values.add(Unassigned);
        GasAssociate = new AccountCode(20, "GasAssociate", "accountcode_gasassociate");
        values.add(GasAssociate);
        Customer = new AccountCode(21, "Customer", "accountcode_customer");
        values.add(Customer);
        USCustomerFutures = new AccountCode(22, "USCustomerFutures", "accountcode_uscustomerfutures");
        values.add(USCustomerFutures);
        USCustomerSwaps = new AccountCode(23, "USCustomerSwaps", "accountcode_uscustomerswaps");
        values.add(USCustomerSwaps);
        USCustomerFBOT = new AccountCode(24, "USCustomerFBOT", "accountcode_uscustomerfbot");
        values.add(USCustomerFBOT);
        Firm = new AccountCode(25, "Firm", "accountcode_firm");
        values.add(Firm);
        MemberCustomerSegregatedAccount = new AccountCode(26, "MemberCustomerSegregatedAccount", "accountcode_membercustomersegregatedaccount");
        values.add(MemberCustomerSegregatedAccount);
        MemberHouseAccount = new AccountCode(27, "MemberHouseAccount", "accountcode_memberhouseaccount");
        values.add(MemberHouseAccount);
        MemberSIPCProtectedAccount = new AccountCode(28, "MemberSIPCProtectedAccount", "accountcode_membersipcprotectedaccount");
        values.add(MemberSIPCProtectedAccount);
        UserProxyForTraderCustomerSegregatedAccount = new AccountCode(29, "UserProxyForTraderCustomerSegregatedAccount", "accountcode_userproxyfortradercustomersegregatedaccount");
        values.add(UserProxyForTraderCustomerSegregatedAccount);
        UserProxyForTraderHouseAccount = new AccountCode(30, "UserProxyForTraderHouseAccount", "accountcode_userproxyfortraderhouseaccount");
        values.add(UserProxyForTraderHouseAccount);
        UserProxyForTraderSIPCProtectedAccount = new AccountCode(31, "UserProxyForTraderSIPCProtectedAccount", "accountcode_userproxyfortradersipcprotectedaccount");
        values.add(UserProxyForTraderSIPCProtectedAccount);
        NonMemberHouseAccount = new AccountCode(32, "NonMemberHouseAccount", "accountcode_nonmemberhouseaccount");
        values.add(NonMemberHouseAccount);
        NonMemberSIPCProtectedAccount = new AccountCode(33, "NonMemberSIPCProtectedAccount", "accountcode_nonmembersipcprotectedaccount");
        values.add(NonMemberSIPCProtectedAccount);
        CustomerFloorBrokerWorkstation = new AccountCode(34, "CustomerFloorBrokerWorkstation", "accountcode_customerfloorbrokerworkstation");
        values.add(CustomerFloorBrokerWorkstation);
        AgentA2 = new AccountCode(35, "AgentA2", "accountcode_agenta2");
        values.add(AgentA2);
        AgentA3 = new AccountCode(36, "AgentA3", "accountcode_agenta3");
        values.add(AgentA3);
        AgentA4 = new AccountCode(37, "AgentA4", "accountcode_agenta4");
        values.add(AgentA4);
        AgentA5 = new AccountCode(38, "AgentA5", "accountcode_agenta5");
        values.add(AgentA5);
        AgentA6 = new AccountCode(39, "AgentA6", "accountcode_agenta6");
        values.add(AgentA6);
        AgentA7 = new AccountCode(40, "AgentA7", "accountcode_agenta7");
        values.add(AgentA7);
        AgentA8 = new AccountCode(41, "AgentA8", "accountcode_agenta8");
        values.add(AgentA8);
        AgentA9 = new AccountCode(42, "AgentA9", "accountcode_agenta9");
        values.add(AgentA9);
        ClientSegregatedE = new AccountCode(43, "ClientSegregatedE", "accountcode_clientsegregatede");
        values.add(ClientSegregatedE);
        ClientSegregatedK = new AccountCode(44, "ClientSegregatedK", "accountcode_clientsegregatedk");
        values.add(ClientSegregatedK);
        ClientSegregatedR = new AccountCode(45, "ClientSegregatedR", "accountcode_clientsegregatedr");
        values.add(ClientSegregatedR);
        SegregatedT = new AccountCode(46, "SegregatedT", "accountcode_segregatedt");
        values.add(SegregatedT);
        IndirectClearingGrossISOC_CASS = new AccountCode(47, "IndirectClearingGrossISOC_CASS", "accountcode_indirectclearinggrossisoc_cass");
        values.add(IndirectClearingGrossISOC_CASS);
        IndirectClearingGrossISOC_TTFCA = new AccountCode(48, "IndirectClearingGrossISOC_TTFCA", "accountcode_indirectclearinggrossisoc_ttfca");
        values.add(IndirectClearingGrossISOC_TTFCA);
        IndirectClearingGrossCASS = new AccountCode(49, "IndirectClearingGrossCASS", "accountcode_indirectclearinggrosscass");
        values.add(IndirectClearingGrossCASS);
        IndirectClearingGrossTTFCA = new AccountCode(50, "IndirectClearingGrossTTFCA", "accountcode_indirectclearinggrossttfca");
        values.add(IndirectClearingGrossTTFCA);
        IndirectClearingNetCASS = new AccountCode(51, "IndirectClearingNetCASS", "accountcode_indirectclearingnetcass");
        values.add(IndirectClearingNetCASS);
        IndirectClearingNetsTTFCA = new AccountCode(52, "IndirectClearingNetsTTFCA", "accountcode_indirectclearingnetsttfca");
        values.add(IndirectClearingNetsTTFCA);
        RO = new AccountCode(53, "RO", "accountcode_ro");
        values.add(RO);
        LiquidityProvider = new AccountCode(54, "LiquidityProvider", "accountcode_liquidityprovider");
        values.add(LiquidityProvider);
        RelatedParty = new AccountCode(55, "RelatedParty", "accountcode_relatedparty");
        values.add(RelatedParty);
        StructuredProductMarketMaker = new AccountCode(56, "StructuredProductMarketMaker", "accountcode_structuredproductmarketmaker");
        values.add(StructuredProductMarketMaker);
        OmegaClient = new AccountCode(57, "OmegaClient", "accountcode_omegaclient");
        values.add(OmegaClient);
        CeresClient = new AccountCode(58, "CeresClient", "accountcode_ceresclient");
        values.add(CeresClient);
        for (AccountCode t : values) {
            map.put(t.getValue(), t);
            names.put(t.name, t);
        }
        mValues = new AccountCode[values.size()];
        values.toArray(mValues);
    }
}

