/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.definitions;

import com.t4login.AsEnum;
import com.t4login.Constant;
import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@AsEnum
public class AccountBuffer {
    private static final String TAG = "AccountBuffer";
    @Constant(value=0)
    public static final AccountBuffer NoSubscription;
    @Constant(value=1)
    public static final AccountBuffer Buffered;
    @Constant(value=2)
    public static final AccountBuffer All;
    private final int value;
    private static Map<Integer, AccountBuffer> map;
    private static AccountBuffer[] mValues;

    AccountBuffer(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountBuffer get(int value) {
        AccountBuffer val = map.get(value);
        if (val == null) {
            Log.e(TAG, "get(), Non-existent value " + Integer.toString(value) + " created and added without name.");
            val = new AccountBuffer(value);
            map.put(value, val);
            ArrayList<AccountBuffer> values = new ArrayList<AccountBuffer>();
            Collections.addAll(values, mValues);
            values.add(val);
            mValues = new AccountBuffer[values.size()];
            values.toArray(mValues);
        }
        return val;
    }

    public AccountBuffer[] values() {
        return mValues;
    }

    public String toString() {
        return "AccountBuffer(" + this.getValue() + ")";
    }

    static {
        map = new HashMap<Integer, AccountBuffer>();
        ArrayList<AccountBuffer> values = new ArrayList<AccountBuffer>();
        NoSubscription = new AccountBuffer(0);
        values.add(NoSubscription);
        Buffered = new AccountBuffer(1);
        values.add(Buffered);
        All = new AccountBuffer(2);
        values.add(All);
        for (AccountBuffer t : values) {
            map.put(t.getValue(), t);
        }
        mValues = new AccountBuffer[values.size()];
        values.toArray(mValues);
    }
}

