/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.datetime;

import java.util.Locale;

public class NTimeSpan {
    public static final long Int64_MaxValue = Long.MAX_VALUE;
    public static final long Int64_MinValue = Long.MIN_VALUE;
    public static final long TicksPerMillisecond = 10000L;
    private static final double MillisecondsPerTick = 1.0E-4;
    public static final long TicksPerSecond = 10000000L;
    private static final double SecondsPerTick = 1.0E-7;
    public static final long TicksPerMinute = 600000000L;
    private static final double MinutesPerTick = 1.6666666666666667E-9;
    public static final long TicksPerHour = 36000000000L;
    private static final double HoursPerTick = 2.7777777777777777E-11;
    public static final long TicksPerDay = 864000000000L;
    private static final double DaysPerTick = 1.1574074074074074E-12;
    private static final int MillisPerSecond = 1000;
    private static final int MillisPerMinute = 60000;
    private static final int MillisPerHour = 3600000;
    private static final int MillisPerDay = 86400000;
    public static final long MaxSeconds = 922337203685L;
    public static final long MinSeconds = -922337203685L;
    public static final long MaxMilliSeconds = 922337203685477L;
    public static final long MinMilliSeconds = -922337203685477L;
    public static final long TicksPerTenthSecond = 1000000L;
    public static final NTimeSpan Zero = new NTimeSpan(0L);
    public static final NTimeSpan MaxValue = new NTimeSpan(Long.MAX_VALUE);
    public static final NTimeSpan MinValue = new NTimeSpan(Long.MIN_VALUE);
    public long _ticks;

    public NTimeSpan(long ticks) {
        this._ticks = ticks;
    }

    public NTimeSpan(int hours, int minutes, int seconds) {
        this._ticks = NTimeSpan.TimeToTicks(hours, minutes, seconds);
    }

    public NTimeSpan(int days, int hours, int minutes, int seconds) {
        this(days, hours, minutes, seconds, 0);
    }

    public NTimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        long totalMilliSeconds = ((long)days * 3600L * 24L + (long)hours * 3600L + (long)minutes * 60L + (long)seconds) * 1000L + (long)milliseconds;
        if (totalMilliSeconds > 922337203685477L || totalMilliSeconds < -922337203685477L) {
            throw new IllegalArgumentException("Overflow_TimeSpanTooLong");
        }
        this._ticks = totalMilliSeconds * 10000L;
    }

    public long getTicks() {
        return this._ticks;
    }

    public int getDays() {
        return (int)(this._ticks / 864000000000L);
    }

    public int getHours() {
        return (int)(this._ticks / 36000000000L % 24L);
    }

    public int getMilliseconds() {
        return (int)(this._ticks / 10000L % 1000L);
    }

    public int getMinutes() {
        return (int)(this._ticks / 600000000L % 60L);
    }

    public int getSeconds() {
        return (int)(this._ticks / 10000000L % 60L);
    }

    public double getTotalDays() {
        return (double)this._ticks * 1.1574074074074074E-12;
    }

    public double getTotalHours() {
        return (double)this._ticks * 2.7777777777777777E-11;
    }

    public double getTotalMilliseconds() {
        double temp = (double)this._ticks * 1.0E-4;
        if (temp > 9.22337203685477E14) {
            return 9.22337203685477E14;
        }
        if (temp < -9.22337203685477E14) {
            return -9.22337203685477E14;
        }
        return temp;
    }

    public double getTotalMinutes() {
        return (double)this._ticks * 1.6666666666666667E-9;
    }

    public double getTotalSeconds() {
        return (double)this._ticks * 1.0E-7;
    }

    public NTimeSpan Add(NTimeSpan ts) {
        long result = this._ticks + ts._ticks;
        if (this._ticks >> 63 == ts._ticks >> 63 && this._ticks >> 63 != result >> 63) {
            throw new IllegalArgumentException("Overflow_TimeSpanTooLong");
        }
        return new NTimeSpan(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTimeSpan nTimeSpan = (NTimeSpan)o;
        return this._ticks == nTimeSpan._ticks;
    }

    public int hashCode() {
        return (int)(this._ticks ^ this._ticks >>> 32);
    }

    public static long TimeToTicks(int hour, int minute, int second) {
        long totalSeconds = (long)hour * 3600L + (long)minute * 60L + (long)second;
        if (totalSeconds > 922337203685L || totalSeconds < -922337203685L) {
            throw new IllegalArgumentException("Overflow_TimeSpanTooLong");
        }
        return totalSeconds * 10000000L;
    }

    public String toString() {
        return String.format(Locale.US, "%02d:%02d:%02d", this.getHours(), this.getMinutes(), this.getSeconds());
    }

    public static NTimeSpan fromMilliseconds(long millis) {
        return new NTimeSpan(millis * 10000L);
    }

    public static NTimeSpan fromString(String timeSpanString) {
        if (timeSpanString.length() == 0) {
            return new NTimeSpan(0, 0, 0);
        }
        String[] parts = timeSpanString.split(":");
        if (parts.length == 3) {
            int hours = Integer.parseInt(parts[0]);
            int minutes = Integer.parseInt(parts[1]);
            int seconds = Integer.parseInt(parts[2]);
            return new NTimeSpan(hours, minutes, seconds);
        }
        if (parts.length == 2) {
            int minutes = Integer.parseInt(parts[0]);
            int seconds = Integer.parseInt(parts[1]);
            return new NTimeSpan(0, minutes, seconds);
        }
        if (parts.length == 1) {
            long ticks = Long.parseLong(parts[0]);
            return new NTimeSpan(ticks);
        }
        return Zero;
    }
}

