/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.datetime;

import com.t4login.Log;
import com.t4login.datetime.DateTimeKind;
import com.t4login.datetime.DayOfWeek;
import com.t4login.datetime.NTimeSpan;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class NDateTime
implements Comparable<NDateTime> {
    private static final String TAG = "NDateTime";
    private static final long TicksPerMillisecond = 10000L;
    private static final long TicksPerSecond = 10000000L;
    private static final long TicksPerMinute = 600000000L;
    private static final long TicksPerHour = 36000000000L;
    private static final long TicksPerDay = 864000000000L;
    public static final int MillisPerSecond = 1000;
    public static final int MillisPerMinute = 60000;
    public static final int MillisPerHour = 3600000;
    public static final int MillisPerDay = 86400000;
    private static final int DaysPerYear = 365;
    private static final int DaysPer4Years = 1461;
    private static final int DaysPer100Years = 36524;
    private static final int DaysPer400Years = 146097;
    private static final int DaysTo1601 = 584388;
    private static final int DaysTo1899 = 693593;
    public static final int DaysTo1970 = 719162;
    private static final int DaysTo10000 = 3652059;
    public static final long MinTicks = 0L;
    public static final long MaxTicks = 3155378975999999999L;
    private static final long MaxMillis = 315537897600000L;
    private static final long FileTimeOffset = 504911232000000000L;
    private static final long DoubleDateOffset = 599264352000000000L;
    private static final long OADateMinAsTicks = 31241376000000000L;
    private static final double OADateMinAsDouble = -657435.0;
    private static final double OADateMaxAsDouble = 2958466.0;
    private static final int DatePartYear = 0;
    private static final int DatePartDayOfYear = 1;
    private static final int DatePartMonth = 2;
    private static final int DatePartDay = 3;
    private static final int[] DaysToMonth365 = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] DaysToMonth366 = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    public static final NDateTime MinValue = new NDateTime(0L, DateTimeKind.Unspecified);
    public static final NDateTime MaxValue = new NDateTime(3155378975999999999L, DateTimeKind.Unspecified);
    public static final NDateTime Epoch = new NDateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);
    private static final long TicksMask = 0x3FFFFFFFFFFFFFFFL;
    private static final long FlagsMask = -4611686018427387904L;
    private static final long LocalMask = Long.MIN_VALUE;
    private static final long TicksCeiling = 0x4000000000000000L;
    private static final long KindUnspecified = 0L;
    private static final long KindUtc = 0x4000000000000000L;
    private static final long KindLocal = Long.MIN_VALUE;
    private static final long KindLocalAmbiguousDst = -4611686018427387904L;
    private static final long KindShift = 62L;
    private long dateData;

    public NDateTime(long ticks) {
        if (ticks < 0L || ticks > 3155378975999999999L) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadTicks");
        }
        this.dateData = ticks;
    }

    public NDateTime(NDateTime dt) {
        this.dateData = dt.dateData;
    }

    public NDateTime(long ticks, DateTimeKind kind) {
        if (ticks < 0L || ticks > 3155378975999999999L) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadTicks");
        }
        this.dateData = ticks | (long)kind.getValue() << 62;
    }

    public NDateTime(int year, int month, int day) {
        this.dateData = NDateTime.DateToTicks(year, month, day);
    }

    public NDateTime(int year, int month, int day, int hour, int minute, int second) {
        this.dateData = NDateTime.DateToTicks(year, month, day) + NDateTime.TimeToTicks(hour, minute, second);
    }

    public NDateTime(int year, int month, int day, int hour, int minute, int second, DateTimeKind kind) {
        long ticks = NDateTime.DateToTicks(year, month, day) + NDateTime.TimeToTicks(hour, minute, second);
        this.dateData = ticks | (long)kind.getValue() << 62;
    }

    public NDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        if (millisecond < 0 || millisecond >= 1000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_Range : millisecond");
        }
        long ticks = NDateTime.DateToTicks(year, month, day) + NDateTime.TimeToTicks(hour, minute, second);
        if ((ticks += (long)millisecond * 10000L) < 0L || ticks > 3155378975999999999L) {
            throw new IllegalArgumentException("Arg_DateTimeRange");
        }
        this.dateData = ticks;
    }

    public NDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, DateTimeKind kind) {
        if (millisecond < 0 || millisecond >= 1000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_Range : millisecond");
        }
        long ticks = NDateTime.DateToTicks(year, month, day) + NDateTime.TimeToTicks(hour, minute, second);
        if ((ticks += (long)millisecond * 10000L) < 0L || ticks > 3155378975999999999L) {
            throw new IllegalArgumentException("Arg_DateTimeRange");
        }
        this.dateData = ticks | (long)kind.getValue() << 62;
    }

    private long getInternalTicks() {
        return this.dateData & 0x3FFFFFFFFFFFFFFFL;
    }

    private long getInternalKind() {
        return this.dateData & 0xC000000000000000L;
    }

    public void set(long ticks) {
        this.dateData = ticks;
    }

    public NDateTime Add(NTimeSpan value) {
        return this.AddTicks(value._ticks);
    }

    public void increment(NTimeSpan value) {
        this.incrementTicks(value._ticks);
    }

    private NDateTime Add(double value, int scale) {
        long millis = (long)(value * (double)scale + (value >= 0.0 ? 0.5 : -0.5));
        if (millis <= -315537897600000L || millis >= 315537897600000L) {
            throw new IllegalArgumentException("ArgumentOutOfRange_AddValue");
        }
        return this.AddTicks(millis * 10000L);
    }

    private void increment(double value, int scale) {
        long millis = (long)(value * (double)scale + (value >= 0.0 ? 0.5 : -0.5));
        if (millis <= -315537897600000L || millis >= 315537897600000L) {
            throw new IllegalArgumentException("ArgumentOutOfRange_AddValue");
        }
        this.incrementTicks(millis * 10000L);
    }

    public NDateTime AddDays(double value) {
        return this.Add(value, 86400000);
    }

    public void incrementDays(double value) {
        this.increment(value, 86400000);
    }

    public NDateTime AddHours(double value) {
        return this.Add(value, 3600000);
    }

    public void incrementHours(double value) {
        this.increment(value, 3600000);
    }

    public NDateTime AddMilliseconds(double value) {
        return this.Add(value, 1);
    }

    public void incrementMilliseconds(double value) {
        this.increment(value, 1);
    }

    public NDateTime AddMinutes(double value) {
        return this.Add(value, 60000);
    }

    public void incrementMinutes(double value) {
        this.increment(value, 60000);
    }

    public NDateTime AddMonths(int months) {
        if (months < -120000 || months > 120000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadMonths");
        }
        int y = this.GetDatePart(0);
        int m = this.GetDatePart(2);
        int d = this.GetDatePart(3);
        int i = m - 1 + months;
        if (i >= 0) {
            m = i % 12 + 1;
            y += i / 12;
        } else {
            m = 12 + (i + 1) % 12;
            y += (i - 11) / 12;
        }
        if (y < 1 || y > 9999) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        int days = NDateTime.DaysInMonth(y, m);
        if (d > days) {
            d = days;
        }
        return new NDateTime(NDateTime.DateToTicks(y, m, d) + this.getInternalTicks() % 864000000000L | this.getInternalKind());
    }

    public void incrementMonths(int months) {
        if (months < -120000 || months > 120000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadMonths");
        }
        int y = this.GetDatePart(0);
        int m = this.GetDatePart(2);
        int d = this.GetDatePart(3);
        int i = m - 1 + months;
        if (i >= 0) {
            m = i % 12 + 1;
            y += i / 12;
        } else {
            m = 12 + (i + 1) % 12;
            y += (i - 11) / 12;
        }
        if (y < 1 || y > 9999) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        int days = NDateTime.DaysInMonth(y, m);
        if (d > days) {
            d = days;
        }
        this.dateData = NDateTime.DateToTicks(y, m, d) + this.getInternalTicks() % 864000000000L | this.getInternalKind();
    }

    public NDateTime AddSeconds(double value) {
        return this.Add(value, 1000);
    }

    public void incrementSeconds(double value) {
        this.increment(value, 1000);
    }

    public NDateTime AddTicks(long value) {
        long ticks = this.getInternalTicks();
        if (value > 3155378975999999999L - ticks || value < 0L - ticks) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        return new NDateTime(ticks + value, this.getKind());
    }

    public void incrementTicks(long value) {
        long ticks = this.getInternalTicks();
        if (value > 3155378975999999999L - ticks || value < 0L - ticks) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        this.dateData = ticks + value | this.getInternalKind();
    }

    public NDateTime AddYears(int value) {
        if (value < -10000 || value > 10000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadYears");
        }
        return this.AddMonths(value * 12);
    }

    public void incrementYears(int value) {
        if (value < -10000 || value > 10000) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateTimeBadYears");
        }
        this.incrementMonths(value * 12);
    }

    public boolean isBefore(NDateTime other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(NDateTime other) {
        return this.compareTo(other) > 0;
    }

    @Override
    public int compareTo(NDateTime another) {
        long valueTicks = another.getInternalTicks();
        long ticks = this.getInternalTicks();
        if (ticks > valueTicks) {
            return 1;
        }
        if (ticks < valueTicks) {
            return -1;
        }
        return 0;
    }

    private static long DateToTicks(int year, int month, int day) {
        if (year >= 1 && year <= 9999 && month >= 1 && month <= 12) {
            int[] days;
            int[] nArray = days = NDateTime.IsLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
            if (day >= 1 && day <= days[month] - days[month - 1]) {
                int y = year - 1;
                int n = y * 365 + y / 4 - y / 100 + y / 400 + days[month - 1] + day - 1;
                return (long)n * 864000000000L;
            }
        }
        throw new IllegalArgumentException("ArgumentOutOfRange_BadYearMonthDay");
    }

    private static long TimeToTicks(int hour, int minute, int second) {
        if (hour >= 0 && hour < 24 && minute >= 0 && minute < 60 && second >= 0 && second < 60) {
            return NTimeSpan.TimeToTicks(hour, minute, second);
        }
        throw new IllegalArgumentException("ArgumentOutOfRange_BadHourMinuteSecond");
    }

    public static int DaysInMonth(int year, int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("ArgumentOutOfRange_Month");
        }
        int[] days = NDateTime.IsLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
        return days[month] - days[month - 1];
    }

    public boolean equals(Object o) {
        long otherTicks;
        if (this == o) {
            return true;
        }
        if (!(o instanceof NDateTime)) {
            return false;
        }
        NDateTime otherDateTime = (NDateTime)o;
        long ticks = this.getInternalTicks();
        return ticks == (otherTicks = otherDateTime.getInternalTicks());
    }

    public int hashCode() {
        return (int)(this.dateData ^ this.dateData >>> 32);
    }

    public NDateTime getDate() {
        long ticks = this.getInternalTicks();
        return new NDateTime(ticks - ticks % 864000000000L | this.getInternalKind());
    }

    private int GetDatePart(int part) {
        int y4;
        int y1;
        int y400;
        int y100;
        long ticks = this.getInternalTicks();
        int n = (int)(ticks / 864000000000L);
        if ((y100 = (n -= (y400 = n / 146097) * 146097) / 36524) == 4) {
            y100 = 3;
        }
        n -= y100 * 36524;
        if ((y1 = (n -= (y4 = n / 1461) * 1461) / 365) == 4) {
            y1 = 3;
        }
        if (part == 0) {
            return y400 * 400 + y100 * 100 + y4 * 4 + y1 + 1;
        }
        n -= y1 * 365;
        if (part == 1) {
            return n + 1;
        }
        boolean leapYear = y1 == 3 && (y4 != 24 || y100 == 3);
        int[] days = leapYear ? DaysToMonth366 : DaysToMonth365;
        int m = n >> 6;
        while (n >= days[m]) {
            ++m;
        }
        if (part == 2) {
            return m;
        }
        return n - days[m - 1] + 1;
    }

    public int getDay() {
        return this.GetDatePart(3);
    }

    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.get((int)((this.getInternalTicks() / 864000000000L + 1L) % 7L));
    }

    public int getDayOfYear() {
        return this.GetDatePart(1);
    }

    public int getHour() {
        return (int)(this.getInternalTicks() / 36000000000L % 24L);
    }

    public DateTimeKind getKind() {
        long intKind = this.getInternalKind();
        if (intKind == 0L) {
            return DateTimeKind.Unspecified;
        }
        if (intKind == 0x4000000000000000L) {
            return DateTimeKind.Utc;
        }
        return DateTimeKind.Local;
    }

    public int getMillisecond() {
        return (int)(this.getInternalTicks() / 10000L % 1000L);
    }

    public int getMinute() {
        return (int)(this.getInternalTicks() / 600000000L % 60L);
    }

    public int getMonth() {
        return this.GetDatePart(2);
    }

    public static NDateTime now() {
        TimeZone tz = TimeZone.getTimeZone("America/Chicago");
        Calendar c = Calendar.getInstance(tz, Locale.US);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        int ms = c.get(14);
        return new NDateTime(year, month, day, hour, minute, second, ms);
    }

    public static NDateTime utcNow() {
        long ctMs = System.currentTimeMillis();
        return Epoch.AddMilliseconds(ctMs);
    }

    public int getSecond() {
        return (int)(this.getInternalTicks() / 10000000L % 60L);
    }

    public long getTicks() {
        return this.getInternalTicks();
    }

    public NTimeSpan getTimeOfDay() {
        return new NTimeSpan(this.getInternalTicks() % 864000000000L);
    }

    public static SimpleDateFormat createDateFormat(String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("America/Chicago"));
        return fmt;
    }

    public static NDateTime today() {
        return NDateTime.now().getDate();
    }

    public int getYear() {
        return this.GetDatePart(0);
    }

    public static boolean IsLeapYear(int year) {
        if (year < 1 || year > 9999) {
            throw new IllegalArgumentException("ArgumentOutOfRange_Year");
        }
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public NTimeSpan Subtract(NDateTime value) {
        return new NTimeSpan(this.getInternalTicks() - value.getInternalTicks());
    }

    public NDateTime Subtract(NTimeSpan value) {
        long valueTicks;
        long ticks = this.getInternalTicks();
        if (ticks - 0L < (valueTicks = value._ticks) || ticks - 3155378975999999999L > valueTicks) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        return new NDateTime(ticks - valueTicks | this.getInternalKind());
    }

    public void decrement(NTimeSpan value) {
        long valueTicks;
        long ticks = this.getInternalTicks();
        if (ticks - 0L < (valueTicks = value._ticks) || ticks - 3155378975999999999L > valueTicks) {
            throw new IllegalArgumentException("ArgumentOutOfRange_DateArithmetic");
        }
        this.dateData = ticks - valueTicks | this.getInternalKind();
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public String toString(SimpleDateFormat fmtr) {
        TimeZone tz = TimeZone.getTimeZone("America/Chicago");
        Calendar c = Calendar.getInstance(tz, Locale.US);
        c.set(1, this.getYear());
        c.set(2, this.getMonth() - 1);
        c.set(5, this.getDay());
        c.set(11, this.getHour());
        c.set(12, this.getMinute());
        c.set(13, this.getSecond());
        c.set(14, this.getMillisecond());
        return fmtr.format(c.getTime());
    }

    public String toString(String fmt) {
        SimpleDateFormat dateFormat = NDateTime.createDateFormat(fmt);
        return this.toString(dateFormat);
    }

    public String toDateString() {
        return String.format("%04d-%02d-%02d", this.getYear(), this.getMonth(), this.getDay());
    }

    public static NDateTime fromDateString(String s) {
        String[] parts = s.split("-");
        if (parts.length < 3) {
            throw new IllegalArgumentException("String '" + s + "' not in format 'YYYY-MM-DD'.");
        }
        int year = Integer.parseInt(parts[0]);
        int month = Integer.parseInt(parts[1]);
        int day = Integer.parseInt(parts[2]);
        return new NDateTime(year, month, day);
    }

    public static NDateTime fromyyyyMMdd(String s) {
        if (s.length() != 8) {
            throw new IllegalArgumentException("String '" + s + "' not in format 'yyyyMMdd'.");
        }
        int year = Integer.parseInt(s.substring(0, 4));
        int month = Integer.parseInt(s.substring(4, 6));
        int day = Integer.parseInt(s.substring(6, 8));
        return new NDateTime(year, month, day);
    }

    public String toShortTimeString() {
        return String.format("%02d:%02d", this.getHour(), this.getMinute());
    }

    public String toTimeString() {
        return String.format("%02d:%02d:%02d", this.getHour(), this.getMinute(), this.getSecond());
    }

    public String toLongtTimeString() {
        return String.format("%02d:%02d:%02d.%03d", this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public static NDateTime fromTimeString(NDateTime date, String s) {
        String[] secparts;
        String[] parts = s.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("String '" + s + "' not in format 'HH:MM:SS.fff'.");
        }
        int hour = Integer.parseInt(parts[0]);
        int minute = Integer.parseInt(parts[1]);
        int second = 0;
        int millisecond = 0;
        if (parts.length >= 3 && (secparts = parts[2].split("\\.")).length >= 1) {
            second = Integer.parseInt(secparts[0]);
            if (secparts.length >= 2) {
                millisecond = Integer.parseInt(secparts[1]);
            }
        }
        return new NDateTime(date.getYear(), date.getMonth(), date.getDay(), hour, minute, second, millisecond);
    }

    public String toDateTimeString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond());
    }

    public static NDateTime fromDateTimeString(String s) {
        String[] parts = s.split(" ");
        if (parts.length < 2) {
            throw new IllegalArgumentException("String '" + s + "' not in format 'YYYY-MM-DD HH:MM:SS.fff'.");
        }
        NDateTime date = NDateTime.fromDateString(parts[0]);
        NDateTime dateTime = NDateTime.fromTimeString(date, parts[1]);
        return dateTime;
    }

    public static NDateTime fromUnixTimeStamp(long epochSeconds) {
        long ticks = NDateTime.epochMSToTicks(epochSeconds * 1000L);
        return new NDateTime(ticks, DateTimeKind.Utc);
    }

    public static NDateTime from(String formattedTime, SimpleDateFormat format) {
        TimeZone tz = TimeZone.getTimeZone("America/Chicago");
        Calendar c = Calendar.getInstance(tz, Locale.US);
        Date date = null;
        try {
            date = format.parse(formattedTime);
            c.setTime(date);
        }
        catch (ParseException e) {
            Log.e(TAG, "Error parsing time '" + formattedTime + "' with format '" + String.valueOf(format) + "'");
            return MinValue;
        }
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        int ms = c.get(14);
        NDateTime cTime = new NDateTime(year, month, day, hour, minute, second, ms);
        return cTime;
    }

    public Date toJavaDate() {
        return new Date(this.toEpochMS());
    }

    public long toEpochMS() {
        long millis = this.getInternalTicks() / 10000L - 62135596800000L;
        if (this.getKind() == DateTimeKind.Utc) {
            return millis;
        }
        TimeZone timeZone = TimeZone.getTimeZone("America/Chicago");
        return millis - (long)timeZone.getOffset(millis);
    }

    public static long ticksToEpochMS(long ticks) {
        return (ticks - 621355968000000000L) / 10000L;
    }

    public static long epochMSToTicks(long epochms) {
        return 621355968000000000L + epochms * 10000L;
    }

    public static NDateTime fromEpochMS(long epochms) {
        return new NDateTime(NDateTime.epochMSToTicks(epochms));
    }
}

