/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import com.t4login.Log;
import com.t4login.connection.Connection;
import com.t4login.connection.ConnectionConfig;
import com.t4login.connection.ConnectionHandler;
import com.t4login.connection.ConnectionState;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.messages.Message;
import com.t4login.messages.MessageArray;
import com.t4login.messages.MessageType;
import com.t4login.messages.MsgApplicationSignal;
import com.t4login.messages.MsgCompressed;
import com.t4login.messages.MsgHeartbeat;
import com.t4login.messages.Util;
import com.t4login.messages.application.SignalType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class T4SSLConnection
implements Connection {
    private static final String TAG = "T4SSLConnection";
    private static EnumSet<MessageType> sLogMessages = EnumSet.noneOf(MessageType.class);
    private ConnectionState mConnectionState = ConnectionState.Created;
    private ConnectionConfig mConnectionConfig = null;
    private boolean mHostNameVerification = true;
    private SSLSocket mSocket = null;
    private MessageReceiver mRecv = null;
    private MessageSender mSend = null;
    private List<ConnectionHandler> mConnectionHandlers = new CopyOnWriteArrayList<ConnectionHandler>();
    private boolean mShouldBeConnected = false;
    private long mServerTimeDiffTicks = 0L;
    private BlockingQueue<Message> recvQueue = new LinkedBlockingQueue<Message>();

    public T4SSLConnection(ConnectionConfig cf) {
        this.mConnectionConfig = cf;
    }

    public void registerConnectionHandler(ConnectionHandler handler) {
        if (!this.mConnectionHandlers.contains(handler)) {
            this.mConnectionHandlers.add(handler);
        }
    }

    public void unregisterConnectionHandler(ConnectionHandler handler) {
        if (this.mConnectionHandlers.contains(handler)) {
            this.mConnectionHandlers.remove(handler);
        }
    }

    public void setEnableHostNameVerification(boolean value) {
        this.mHostNameVerification = value;
    }

    private void onConnected() {
        for (ConnectionHandler hndlr : this.mConnectionHandlers) {
            try {
                hndlr.connected(this);
            }
            catch (Exception ex) {
                Log.e(TAG, "onConnected(), Callback handler raised an unhandled exception.", ex);
            }
        }
    }

    private void onDisconnected(String reason) {
        for (ConnectionHandler hndlr : this.mConnectionHandlers) {
            try {
                hndlr.disconnected(this, reason);
            }
            catch (Exception ex) {
                Log.e(TAG, "onDisconnected(), Callback handler raised an unhandled exception.", ex);
            }
        }
    }

    private void onConnectFailed(String reason) {
        for (ConnectionHandler hndlr : this.mConnectionHandlers) {
            try {
                hndlr.connectFailed(this, reason);
            }
            catch (Exception ex) {
                Log.e(TAG, "onConnectFailed(), Callback handler raised an unhandled exception.", ex);
            }
        }
    }

    private void onMessage(Message message) {
        for (ConnectionHandler hndlr : this.mConnectionHandlers) {
            try {
                hndlr.message(this, message);
            }
            catch (Exception ex) {
                Log.e(TAG, "onMessage(), Callback handler raised an unhandled exception.", ex);
            }
        }
    }

    @Override
    public synchronized void connect() {
        this.mShouldBeConnected = true;
        Log.d(TAG, String.format("Establishing ssl connection to: %s", this.mConnectionConfig));
        try {
            SocketFactory sf = SSLSocketFactory.getDefault();
            this.mSocket = (SSLSocket)sf.createSocket(this.mConnectionConfig.getHostAddress(), this.mConnectionConfig.getPort());
            this.mConnectionState = ConnectionState.Connected;
            Log.d(TAG, "SSL socket connection established.");
            this.mRecv = new MessageReceiver(this.mSocket.getInputStream());
            Thread recvThread = new Thread(this.mRecv);
            recvThread.start();
            this.mSend = new MessageSender(this, this.mSocket.getOutputStream());
            Thread sendThread = new Thread(this.mSend);
            sendThread.start();
            this.onConnected();
            this.processRecvMessages();
        }
        catch (Exception ex) {
            Log.e(TAG, "connect(), [" + this.mConnectionConfig.getName() + "/" + this.mConnectionConfig.getHostAddress() + "], Connect failed: " + String.valueOf(ex));
            this.onConnectFailed("Unable to connect.");
        }
    }

    @Override
    public void close() {
        this.close("Connection closed by request.");
    }

    public void close(String reason) {
        if (this.mSocket != null) {
            this.mShouldBeConnected = false;
            Log.d(TAG, "close(), Closing SSL socket connection. Reason: " + reason);
            this.mConnectionState = ConnectionState.Disconnecting;
            try {
                if (this.mSend != null) {
                    this.mSend.setStopping();
                    this.mSend.queueMessage(new MsgApplicationSignal(SignalType.SocketClosing));
                }
                if (this.mRecv != null) {
                    this.mRecv.setStopping();
                }
                this.recvQueue.put(new MsgApplicationSignal(SignalType.SocketClosing));
                this.mSocket.close();
                this.mSocket = null;
                this.mRecv = null;
                this.mSend = null;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
            finally {
                this.mSocket = null;
                this.mConnectionState = ConnectionState.Closed;
                Log.d(TAG, "Socket closed.");
                this.onDisconnected("Connection closed by request.");
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected();
    }

    @Override
    public boolean shouldBeConnected() {
        return this.mShouldBeConnected;
    }

    @Override
    public boolean sendMessage(Message msg) {
        if (this.isConnected() && this.mSend != null) {
            this.mSend.queueMessage(msg);
            return true;
        }
        Log.e(TAG, "Attempted to send a message but the socket is not connected.");
        return false;
    }

    @Override
    public NDateTime getRemoteTime() {
        return NDateTime.now().AddTicks(this.mServerTimeDiffTicks);
    }

    @Override
    public NDateTime getRemoteTime(NDateTime time) {
        return time.AddTicks(this.mServerTimeDiffTicks);
    }

    protected void receiveMessage(Message msg) {
        this.recvQueue.add(msg);
    }

    private void processRecvMessages() {
        while (this.isConnected() && this.mConnectionState == ConnectionState.Connected) {
            Message msg = null;
            try {
                msg = this.recvQueue.take();
            }
            catch (InterruptedException iex) {
                Log.e(TAG, "Receive queue interruption.");
            }
            if (msg != null && msg.getMessageType().equals((Object)MessageType.SignalMessage)) {
                Log.d(TAG, "processRecvMessages(), Receive queue thread exiting.");
                return;
            }
            if (msg != null) {
                this.processMessage(msg);
                continue;
            }
            this.close();
            break;
        }
    }

    private void processMessage(Message msg) {
        switch (msg.getMessageType()) {
            case SignalMessage: {
                this.processSignalMessage(msg);
                break;
            }
            case Heartbeat: {
                this.processHeartbeatMessage((MsgHeartbeat)msg);
                this.onMessage(msg);
                break;
            }
            case HeartbeatResponse: {
                this.processHeartbeatResponseMessage(msg);
                this.onMessage(msg);
                break;
            }
            case Compressed: {
                MsgCompressed cmsg = (MsgCompressed)msg;
                if (cmsg.PackedMessage == null) break;
                this.processMessage(cmsg.PackedMessage);
                break;
            }
            case MessageArray: {
                MessageArray msgarr = (MessageArray)msg;
                for (Message amsg : msgarr.getMessages()) {
                    this.processMessage(amsg);
                }
                break;
            }
            default: {
                this.logRecvMessage(msg);
                this.onMessage(msg);
            }
        }
    }

    private void logRecvMessage(Message msg) {
        if (Log.debugMode() && sLogMessages.contains((Object)msg.getMessageType())) {
            Log.d(TAG, "RCV(" + this.mConnectionConfig.getHostAddress() + "): " + String.valueOf(msg));
            if (msg instanceof Iterable) {
                for (Message childMsg : (Iterable)((Object)msg)) {
                    if (!sLogMessages.contains((Object)childMsg.getMessageType())) continue;
                    Log.d(TAG, "RCV(" + this.mConnectionConfig.getHostAddress() + ") >> : " + String.valueOf(childMsg));
                }
            }
        }
    }

    private void logSendMessage(Message msg) {
        if (Log.debugMode() && sLogMessages.contains((Object)msg.getMessageType())) {
            Log.d(TAG, "SENT(" + this.mConnectionConfig.getHostAddress() + "): " + String.valueOf(msg));
        }
    }

    private void processSignalMessage(Message msg) {
        Log.w(TAG, "processSignalMessage(), Signal: " + String.valueOf(msg));
    }

    private void processHeartbeatMessage(MsgHeartbeat msg) {
        try {
            long preTimeDiff = this.mServerTimeDiffTicks;
            this.mServerTimeDiffTicks = msg.getTimeStamp() - NDateTime.now().getTicks();
            Log.v(TAG, "processHeartbeatMessage(), Time Diff: " + String.valueOf(new NTimeSpan(this.mServerTimeDiffTicks)) + ", Change : " + String.valueOf(new NTimeSpan(this.mServerTimeDiffTicks - preTimeDiff)));
        }
        catch (Exception ex) {
            Log.e(TAG, "processHeartbeatMessage(), Error while computing server time difference.", ex);
        }
    }

    private void processHeartbeatResponseMessage(Message msg) {
    }

    static {
        sLogMessages.add(MessageType.Login);
        sLogMessages.add(MessageType.LoginResponse2);
    }

    class MessageReceiver
    implements Runnable {
        private InputStream in;
        private boolean stopping = false;
        private int seq = 0;

        public MessageReceiver(InputStream in) {
            this.in = new BufferedInputStream(in);
        }

        private void setStopping() {
            this.stopping = true;
        }

        @Override
        public void run() {
            block8: {
                this.seq = 0;
                try {
                    while (T4SSLConnection.this.mConnectionState == ConnectionState.Connected) {
                        int msgRecvSeq = Message.readInteger(this.in);
                        Message msg = Message.getMessage(this.in);
                        int msgHash = Message.readInteger(this.in);
                        if (msgRecvSeq == this.seq) {
                            ++this.seq;
                            if (msg == null) continue;
                            if (msg.getMessageType() == MessageType.Disconnecting) {
                                T4SSLConnection.this.close();
                            }
                            T4SSLConnection.this.receiveMessage(msg);
                            continue;
                        }
                        if (msgRecvSeq > this.seq) {
                            Log.e(T4SSLConnection.TAG, "MessageReceiver.run(), Duplicate sequence number received (ignoring): " + msgRecvSeq + ", next expected seq: " + this.seq + ", msg: " + msg.toString());
                            continue;
                        }
                        Log.e(T4SSLConnection.TAG, "MessageReceiver.run(), Received seq: " + msgRecvSeq + ", expected: " + this.seq + ", Disconnecting.");
                        T4SSLConnection.this.close("Sequence error, received: " + msgRecvSeq + ", expected: " + this.seq);
                    }
                }
                catch (IOException ioex) {
                    if (this.stopping) break block8;
                    Log.e(T4SSLConnection.TAG, "MessageReceiver.run()", ioex);
                    T4SSLConnection.this.close("Socket exception: " + ioex.getMessage());
                }
            }
            try {
                this.in.close();
            }
            catch (IOException ioex) {
                Log.e(T4SSLConnection.TAG, "MessageReceiver", ioex);
            }
            Log.d(T4SSLConnection.TAG, "MessageReceiver.run(), Socket receive thread exiting.");
        }
    }

    class MessageSender
    implements Runnable {
        T4SSLConnection connection;
        private OutputStream out;
        private BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>(1);
        private int seq = 0;
        private boolean running = true;
        private long lastMessageSendTime = System.currentTimeMillis();

        public MessageSender(T4SSLConnection conn, OutputStream out) {
            this.connection = conn;
            this.out = new BufferedOutputStream(out);
        }

        private void setStopping() {
            this.running = false;
        }

        public void queueMessage(Message msg) {
            if (this.running) {
                try {
                    this.queue.offer(msg, 500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Log.e(T4SSLConnection.TAG, "MessageSender.queueMessage(), Error.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    Message msg = null;
                    try {
                        msg = this.queue.poll(30L, TimeUnit.SECONDS);
                        if (msg == null && System.currentTimeMillis() - this.lastMessageSendTime >= 30000L) {
                            msg = new MsgHeartbeat().setTimeStamp(Util.epochMSToTicks(System.currentTimeMillis()));
                        }
                    }
                    catch (InterruptedException iex) {
                        Log.e(T4SSLConnection.TAG, "Message sender queue interruption.");
                    }
                    if (!this.running) {
                        return;
                    }
                    if (msg != null && msg.getMessageType().equals((Object)MessageType.SignalMessage)) {
                        Log.d(T4SSLConnection.TAG, "MessageSender.run(), Socket send thread exiting.");
                        this.running = false;
                        return;
                    }
                    if (msg == null) continue;
                    Message.writeInteger(this.out, this.seq);
                    ++this.seq;
                    Message.writeShort(this.out, (short)msg.getMessageType().getValue());
                    Message.writeShort(this.out, msg.getMessageType().getVersion());
                    byte[] msgData = msg.getBytes();
                    Message.writeInteger(this.out, msgData.length);
                    this.out.write(msgData);
                    Integer hash = 0;
                    for (int i = 0; i < msgData.length - 1; ++i) {
                        int ub = msgData[i] & 0xFF;
                        hash = hash + ub;
                    }
                    Message.writeInteger(this.out, hash);
                    this.out.flush();
                    T4SSLConnection.this.logSendMessage(msg);
                    this.resetHeartbeat();
                }
                this.out.close();
                return;
            }
            catch (IOException ioex) {
                if (!this.running) return;
                Log.e(T4SSLConnection.TAG, "MessageSender.run(), IOException", ioex);
                this.connection.close();
                return;
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void resetHeartbeat() {
            this.lastMessageSendTime = System.currentTimeMillis();
        }
    }
}

