/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import com.t4login.Resource;
import java.util.HashMap;
import java.util.Map;

public enum ServerType {
    Live(1, 1, "servers_live", "servers_live_abbr", "https://server.t4login.com|http://www.t4login.com", "https://www.t4login.com/LIVE/Login.aspx?firm=", "https://api.t4login.com", "live"),
    Simulator(2, 2, "servers_simulator", "servers_simulator_abbr", "https://server.sim.t4login.com", "https://www.sim.t4login.com/SimAdmin/Login.aspx?firm=", "https://api-sim.t4login.com", "simulator"),
    Test(3, 3, "servers_test", "servers_test_abbr", "https://www-test.t4login.com", "https://www-test.t4login.com/Live/Login.aspx?firm=", "https://api-test.t4login.com", "test"),
    Unknown(9999, 9999, "servers_unknown", "servers_unknown_abbr", "unknown_urls", "unknown_admin_url", "", "unknown");

    private static final String TAG = "ServerType";
    private final int value;
    private final int serverType;
    private final String descr_loc;
    private final String abbrDescr_loc;
    private final String urls;
    private final String firmAdminURL;
    private final String apiBaseURL;
    private final String notificationGroup;
    private static final Map<Integer, ServerType> map;
    private static final Map<String, ServerType> nameMap;

    private ServerType(int value, int serverType, String descr_loc, String abbrDescr_loc, String urls, String adminURL, String apiBaseURL, String notificationGroup) {
        this.value = value;
        this.serverType = serverType;
        this.descr_loc = descr_loc;
        this.abbrDescr_loc = abbrDescr_loc;
        this.urls = urls;
        this.firmAdminURL = adminURL;
        this.apiBaseURL = apiBaseURL;
        this.notificationGroup = notificationGroup;
    }

    public String getDescr() {
        return Resource.localizeString(this.descr_loc);
    }

    public String getAbbrDescr() {
        return Resource.localizeString(this.abbrDescr_loc);
    }

    public String getNotificationGroup() {
        return this.notificationGroup;
    }

    public int getValue() {
        return this.value;
    }

    public int getServerType() {
        return this.serverType;
    }

    public String[] getUrls() {
        return this.urls.split("\\|");
    }

    public String[] getMarketDataURLs() {
        String[] urls = this.getUrls();
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = urls[i] + "/marketdata/active/";
        }
        return urls;
    }

    public String getFirmAdminURL(String firm) {
        return this.firmAdminURL + firm;
    }

    public String getAPIBaseURL() {
        return this.apiBaseURL;
    }

    public static ServerType get(int value) {
        return map.get(value);
    }

    public static ServerType fromName(String name) {
        return nameMap.get(name);
    }

    static {
        map = new HashMap<Integer, ServerType>();
        nameMap = new HashMap<String, ServerType>();
        for (ServerType t : ServerType.values()) {
            map.put(t.getValue(), t);
            nameMap.put(t.name(), t);
        }
    }
}

