/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long totalBytesRead;
    private long mark = -1L;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public long getCount() {
        return this.totalBytesRead;
    }

    public void resetCount() {
        this.totalBytesRead = 0L;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.totalBytesRead;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n != -1) {
            this.totalBytesRead += (long)n;
        }
        return n;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long n = this.in.skip(byteCount);
        if (n != -1L) {
            this.totalBytesRead += n;
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.totalBytesRead;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.totalBytesRead = this.mark;
    }
}

