/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import com.t4login.Log;
import com.t4login.api.GetServersResponse;
import com.t4login.connection.ConnectionClass;
import com.t4login.connection.ConnectionConfig;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConnectionConfigXmlParser {
    private static final String TAG = "ConnectionConfigXmlParser";
    private static final String ns = null;
    private boolean mBadCredentials = false;
    private String mURL = "";
    private Set<SimpleSignInMethod> mSSI = new HashSet<SimpleSignInMethod>();
    private boolean mSSISupported = false;
    private List<ConnectionConfig> connections = new ArrayList<ConnectionConfig>();
    private String apiMessage = "";
    private HashMap<String, String> mContactInfo = new HashMap();

    public boolean getBadCredentials() {
        return this.mBadCredentials;
    }

    public String getURL() {
        return this.mURL;
    }

    public boolean getSSISupported() {
        return this.mSSISupported;
    }

    public Set<SimpleSignInMethod> getSSI() {
        return this.mSSI;
    }

    public List<ConnectionConfig> getConnections() {
        return this.connections;
    }

    public String getAPIMessage() {
        if (this.apiMessage == null) {
            return "";
        }
        return this.apiMessage;
    }

    public String getContactInfo() {
        String culture = Locale.getDefault().toString().replace('_', '-');
        return this.getContactInfo(culture);
    }

    public String getContactInfo(String culture) {
        String contactInfo = this.mContactInfo.get(culture);
        if (contactInfo == null) {
            contactInfo = this.mContactInfo.get("en-US");
        }
        if (contactInfo == null) {
            contactInfo = "";
        }
        return contactInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput(in, null);
            parser.nextTag();
            String name = parser.getName();
            if (name.equalsIgnoreCase("T4API")) {
                this.connections = this.readT4API(parser);
            } else if (name.equalsIgnoreCase("HTML")) {
                this.apiMessage = this.readAPIMessage(parser);
            } else {
                Log.e(TAG, "Unexpected tag in config file: '" + name + "'. Expected <T4API> or <HTML>.");
            }
        }
        finally {
            in.close();
        }
    }

    public GetServersResponse asGetServersResponse() {
        GetServersResponse resp = new GetServersResponse();
        resp.url = this.mURL;
        resp.ssiMethods = SimpleSignInMethod.toFlags(this.mSSI);
        resp.support = this.mContactInfo;
        resp.message = this.apiMessage != null ? this.apiMessage : "";
        resp.systemStatus = "";
        resp.newVersion = new GetServersResponse.Version();
        resp.newVersion.url = "";
        resp.newVersion.upgradeURL = "";
        resp.newVersion.betaURL = "";
        resp.newVersion.latestVersion = "";
        resp.newVersion.betaLatestVersion = "";
        resp.newVersion.version = "";
        resp.newVersion.minVersion = "";
        resp.connections = this.connections.stream().filter(c -> c.getConnectionClass().equals((Object)ConnectionClass.ExecuteAndQuote)).map(c -> {
            GetServersResponse.Connection conn = new GetServersResponse.Connection();
            conn.hostAddress = String.format(Locale.US, "%s:%d", c.getHostAddress(), c.getPort());
            conn.type = c.getConnectionType();
            conn.timer = String.format(Locale.US, "%d", c.getTimeOutMS());
            conn.maxPendingHeartbeats = String.format(Locale.US, "%d", c.getMaxPendingHeartbeats());
            conn.internetProvider = c.getDomain();
            return conn;
        }).collect(Collectors.toList());
        resp.chartDataConnections = this.connections.stream().filter(c -> c.getConnectionClass().equals((Object)ConnectionClass.ChartData)).map(c -> {
            GetServersResponse.Connection conn = new GetServersResponse.Connection();
            conn.hostAddress = String.format(Locale.US, "%s:%d", c.getHostAddress(), c.getPort());
            conn.type = c.getConnectionType();
            conn.timer = String.format(Locale.US, "%d", c.getTimeOutMS());
            conn.maxPendingHeartbeats = String.format(Locale.US, "%d", c.getMaxPendingHeartbeats());
            conn.internetProvider = c.getDomain();
            return conn;
        }).collect(Collectors.toList());
        return resp;
    }

    private String readAPIMessage(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "html");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("body")) {
                while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    String name1 = parser.getName();
                    String id1 = parser.getAttributeValue(null, "id");
                    if (name1.equalsIgnoreCase("p") && id1 != null && id1.equalsIgnoreCase("apimsg")) {
                        if (parser.next() != 4) continue;
                        return parser.getText();
                    }
                    this.skip(parser);
                }
                continue;
            }
            this.skip(parser);
        }
        return "";
    }

    private List<ConnectionConfig> readT4API(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<ConnectionConfig> connections = new ArrayList<ConnectionConfig>();
        parser.require(2, ns, "T4API");
        this.apiMessage = parser.getAttributeValue(null, "FailReason");
        if (this.apiMessage != null && this.apiMessage.length() > 0) {
            this.mBadCredentials = true;
            return connections;
        }
        this.mURL = parser.getAttributeValue(null, "URL");
        String ssiValue = parser.getAttributeValue(null, "SSI");
        if (ssiValue != null && ssiValue.length() > 0) {
            this.mSSISupported = true;
            this.mSSI = SimpleSignInMethod.fromFlags(Integer.parseInt(ssiValue));
        } else {
            this.mSSISupported = false;
        }
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equalsIgnoreCase("Connections")) {
                connections.addAll(this.readConnections(parser, ConnectionClass.ExecuteAndQuote));
                continue;
            }
            if (name.equals("ChartDataConnections")) {
                connections.addAll(this.readConnections(parser, ConnectionClass.ChartData));
                continue;
            }
            if (name.equalsIgnoreCase("Support")) {
                this.readSupportConfigs(parser);
                continue;
            }
            this.skip(parser);
        }
        return connections;
    }

    private List<ConnectionConfig> readConnections(XmlPullParser parser, ConnectionClass connClass) throws XmlPullParserException, IOException {
        if (connClass == ConnectionClass.ExecuteAndQuote) {
            parser.require(2, ns, "Connections");
        } else if (connClass == ConnectionClass.ChartData) {
            parser.require(2, ns, "ChartDataConnections");
        }
        ArrayList<ConnectionConfig> connections = new ArrayList<ConnectionConfig>();
        while (parser.next() != 3) {
            ConnectionConfig cf;
            if (parser.getEventType() != 2 || (cf = this.readConnection(parser, connClass)) == null) continue;
            connections.add(cf);
        }
        return connections;
    }

    private ConnectionConfig readConnection(XmlPullParser parser, ConnectionClass connClass) throws XmlPullParserException, IOException {
        String[] parts;
        String name = parser.getName();
        String hostAddress = parser.getAttributeValue(null, "HostAddress");
        int port = 443;
        if (hostAddress != null && (parts = hostAddress.split(":")).length > 1) {
            hostAddress = parts[0];
            port = Integer.parseInt(parts[1]);
        }
        String connectionType = parser.getAttributeValue(null, "Type");
        String timeOutMSStr = parser.getAttributeValue(null, "Timer");
        String maxPendingHeartbeatsStr = parser.getAttributeValue(null, "MaxPendingHeartbeats");
        parser.nextTag();
        parser.require(3, ns, name);
        int timeOutMS = 30000;
        int maxPendingHeartbeats = 3;
        if (timeOutMSStr != null) {
            timeOutMS = Integer.parseInt(timeOutMSStr);
        }
        if (maxPendingHeartbeatsStr != null) {
            maxPendingHeartbeats = Integer.parseInt(maxPendingHeartbeatsStr);
        }
        if (name != null && hostAddress != null && connectionType != null) {
            return new ConnectionConfig(connClass, name, hostAddress, port, connectionType, timeOutMS, maxPendingHeartbeats);
        }
        return null;
    }

    private void readSupportConfigs(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.mContactInfo.clear();
        parser.require(2, ns, "Support");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String culture = parser.getName();
            String contact = this.getInnerXml(parser);
            if (contact == null) continue;
            this.mContactInfo.put(culture, contact);
        }
    }

    private void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.nextToken()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    private String getInnerXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        StringBuilder sb = new StringBuilder();
        int depth = 1;
        block4: while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    if (--depth <= 0) continue block4;
                    sb.append("</").append(parser.getName()).append(">");
                    continue block4;
                }
                case 2: {
                    ++depth;
                    StringBuilder attrs = new StringBuilder();
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrs.append(parser.getAttributeName(i)).append("=\"").append(parser.getAttributeValue(i)).append("\" ");
                    }
                    sb.append("<").append(parser.getName()).append(" ").append(attrs.toString()).append(">");
                    continue block4;
                }
            }
            sb.append(parser.getText());
        }
        return sb.toString();
    }
}

