/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import com.t4login.connection.ConnectionClass;

public class ConnectionConfig {
    private final ConnectionClass connectionClass;
    private final String name;
    private final String hostAddress;
    private final int port;
    private final String connectionType;
    private final int timeOutMS;
    private final int maxPendingHeartbeats;

    public ConnectionConfig(ConnectionClass connClass, String name, String hostAddr, int port, String connType, int timeOut, int maxPendingHeartbeats) {
        this.connectionClass = connClass;
        this.name = name;
        this.hostAddress = hostAddr;
        this.port = port;
        this.connectionType = connType;
        this.timeOutMS = timeOut;
        this.maxPendingHeartbeats = maxPendingHeartbeats;
    }

    public ConnectionClass getConnectionClass() {
        return this.connectionClass;
    }

    public String getName() {
        return this.name;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public int getTimeOutMS() {
        return this.timeOutMS;
    }

    public int getMaxPendingHeartbeats() {
        return this.maxPendingHeartbeats;
    }

    public String toString() {
        return String.format("class: %s, name: %s, addr: %s:%d, type: %s, timeout(ms): %d, maxpendingheartbeats: %d", new Object[]{this.connectionClass, this.name, this.hostAddress, this.port, this.connectionType, this.timeOutMS, this.maxPendingHeartbeats});
    }

    public String getDomain() {
        String[] parts = this.hostAddress.split("\\.");
        Object domain = this.hostAddress;
        if (parts.length > 2) {
            domain = parts[parts.length - 2] + "." + parts[parts.length - 1];
        }
        return domain;
    }
}

