/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.connection;

import com.t4login.Host;
import com.t4login.Log;
import com.t4login.api.UserData;
import com.t4login.connection.Connection;
import com.t4login.connection.ConnectionConfig;
import com.t4login.connection.ConnectionHandler;
import com.t4login.connection.IHostConnection;
import com.t4login.connection.T4SSLConnection;
import com.t4login.datetime.NDateTime;
import com.t4login.datetime.NTimeSpan;
import com.t4login.definitions.LoginResult;
import com.t4login.messages.Message;
import com.t4login.messages.MessageType;
import com.t4login.messages.MsgLogin;
import com.t4login.messages.MsgLoginResponse2;
import com.t4login.messages.MsgSSIChallenge;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class AndroidHostConnection
implements IHostConnection {
    private static final String TAG = "HostConnection";
    private static final double MAX_IDLE_SECONDS = 180.0;
    private final String mDescription;
    private final UserData mUserData;
    private T4SSLConnection mConnection = null;
    private final List<ConnectionConfig> mConnections;
    private int mLastConnection = 0;
    private IHostConnection.ConnState mConnState = IHostConnection.ConnState.Disconnected;
    private boolean mLoggedIn = false;
    private boolean mFirstLogin = true;
    private int mConectFailCount = 0;
    private Timer mHeartBeatTimer = null;
    private volatile NDateTime mLastRecieveTime = NDateTime.now();
    private IHostConnection.HostConnectionHandler mCallbackHandler = null;
    private ConnectionHandler mConnectionHandler = new ConnectionHandler(){

        @Override
        public void message(Connection connection, Message msg) {
            AndroidHostConnection.this.mLastRecieveTime = NDateTime.now();
            if (msg.getMessageType() == MessageType.Heartbeat || msg.getMessageType() == MessageType.HeartbeatResponse) {
                return;
            }
            AndroidHostConnection.this.onMessage(msg);
            if (msg.getMessageType() == MessageType.LoginResponse2) {
                MsgLoginResponse2 loginResponse = (MsgLoginResponse2)msg;
                if (loginResponse.Result == LoginResult.LoggedInElsewhere) {
                    AndroidHostConnection.this.doDisconnect(false);
                    AndroidHostConnection.this.mConnState = IHostConnection.ConnState.Disconnected;
                } else if (!AndroidHostConnection.this.mLoggedIn && loginResponse.Result == LoginResult.Success) {
                    AndroidHostConnection.this.mLoggedIn = true;
                    AndroidHostConnection.this.onLoggedIn(AndroidHostConnection.this.mFirstLogin);
                    AndroidHostConnection.this.mFirstLogin = false;
                }
            }
        }

        @Override
        public void disconnected(Connection connection, String reason) {
            Log.d(AndroidHostConnection.TAG, "disconnected(), [" + AndroidHostConnection.this.mDescription + "], Disconnected: " + String.valueOf(AndroidHostConnection.this.mConnections.get(AndroidHostConnection.this.mLastConnection)) + ", Reason: " + reason);
            boolean wasLoggedIn = AndroidHostConnection.this.mLoggedIn;
            AndroidHostConnection.this.mLoggedIn = false;
            AndroidHostConnection.this.onDisconnected(reason);
            if (AndroidHostConnection.this.mConnState == IHostConnection.ConnState.Connected && wasLoggedIn) {
                AndroidHostConnection.this.beginConnect();
            }
        }

        @Override
        public void connected(Connection connection) {
            Log.d(AndroidHostConnection.TAG, "connected(), [" + AndroidHostConnection.this.mDescription + "], Connected: " + String.valueOf(AndroidHostConnection.this.mConnections.get(AndroidHostConnection.this.mLastConnection)));
            AndroidHostConnection.this.mConectFailCount = 0;
            AndroidHostConnection.this.mLastRecieveTime = NDateTime.now();
            AndroidHostConnection.this.mHeartBeatTimer = new Timer(AndroidHostConnection.this.mDescription);
            AndroidHostConnection.this.mHeartBeatTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AndroidHostConnection.this.onHeartBeatTimer();
                }
            }, 5L, 5L);
            AndroidHostConnection.this.doLogin();
        }

        @Override
        public void connectFailed(Connection connection, String reason) {
            ++AndroidHostConnection.this.mConectFailCount;
            if (AndroidHostConnection.this.mConnState == IHostConnection.ConnState.Connected) {
                int postDelay;
                if (AndroidHostConnection.this.mConectFailCount > 60) {
                    Log.e(AndroidHostConnection.TAG, "connectFailed(), [" + AndroidHostConnection.this.mDescription + "], FailCount: " + AndroidHostConnection.this.mConectFailCount + ", Next attempt in 5 seconds.");
                    postDelay = 5000;
                } else if (AndroidHostConnection.this.mConectFailCount > 5) {
                    Log.e(AndroidHostConnection.TAG, "connectFailed(), [" + AndroidHostConnection.this.mDescription + "], FailCount: " + AndroidHostConnection.this.mConectFailCount + ", Next attempt in 1 second.");
                    postDelay = 1000;
                } else {
                    Log.e(AndroidHostConnection.TAG, "connectFailed(), [" + AndroidHostConnection.this.mDescription + "], FailCount: " + AndroidHostConnection.this.mConectFailCount + ", Re-attempting.");
                    postDelay = 0;
                }
                AndroidHostConnection.this.beginConnect(postDelay);
            }
        }
    };

    public AndroidHostConnection(String description, UserData userData, List<ConnectionConfig> connections, IHostConnection.HostConnectionHandler hndlr) {
        this.mDescription = description;
        this.mUserData = userData;
        this.mConnections = connections;
        this.mCallbackHandler = hndlr;
    }

    @Override
    public void setConnectionHandler(IHostConnection.HostConnectionHandler hndlr) {
        this.mCallbackHandler = hndlr;
    }

    @Override
    public void start() {
        this.mConnState = IHostConnection.ConnState.Connected;
        this.doConnect();
    }

    @Override
    public void beginStart() {
        this.mConnState = IHostConnection.ConnState.Connected;
        this.beginConnect();
    }

    @Override
    public void stop() {
        this.mConnState = IHostConnection.ConnState.Disconnected;
        this.doDisconnect(true);
    }

    @Override
    public boolean sendMessage(Message msg) {
        if (this.mConnection != null && this.mConnection.isConnected()) {
            if (this.mLoggedIn || msg.getMessageType() == MessageType.TwoFactorAuthentication) {
                return this.mConnection.sendMessage(msg);
            }
            Log.e(TAG, "sendMessage(), [" + this.mDescription + "], Send failed. Not logged in. Message: " + msg.toString());
            return false;
        }
        Log.e(TAG, "sendMessage(), [" + this.mDescription + "], Send failed. Not connected. Message: " + msg.toString());
        return false;
    }

    @Override
    public NDateTime getRemoteTime() {
        if (this.mConnection != null) {
            return this.mConnection.getRemoteTime();
        }
        return NDateTime.now();
    }

    @Override
    public NDateTime getRemoteTime(NDateTime time) {
        if (this.mConnection != null) {
            return this.mConnection.getRemoteTime(time);
        }
        return time;
    }

    @Override
    public boolean isConnected() {
        return this.mLoggedIn;
    }

    private void beginConnect() {
        this.beginConnect(0);
    }

    private void beginConnect(int delayMS) {
        if (this.mHeartBeatTimer != null) {
            this.mHeartBeatTimer.cancel();
            this.mHeartBeatTimer = null;
        }
        final int dlms = delayMS;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(dlms);
                }
                catch (InterruptedException iex) {
                    Log.e(AndroidHostConnection.TAG, "beginConnect(), Error.", iex);
                }
                AndroidHostConnection.this.doConnect();
            }
        });
        thread.start();
    }

    private void doConnect() {
        this.doDisconnect(true);
        if (this.mConnState == IHostConnection.ConnState.Connected) {
            this.mLastConnection = (this.mLastConnection + 1) % this.mConnections.size();
            ConnectionConfig conn = this.mConnections.get(this.mLastConnection);
            this.mConnection = new T4SSLConnection(conn);
            this.mConnection.registerConnectionHandler(this.mConnectionHandler);
            String hn = conn.getHostAddress();
            if (hn.contains("test")) {
                this.mConnection.setEnableHostNameVerification(false);
            }
            Log.d(TAG, "doConnect(), [" + this.mDescription + "], Connecting: " + String.valueOf(conn));
            this.mConnection.connect();
        }
    }

    private void doLogin() {
        this.doLogin(null);
    }

    private void doLogin(byte[] ssiChallenge) {
        MsgLogin login = new MsgLogin();
        this.mUserData.getLoginDetail(login, ssiChallenge);
        login.Version = Host.getApplicationVersion();
        login.APIVersion = Host.getAPIVersion();
        login.OSPlatform = Host.getPlatformName();
        login.OSVersion = Host.getOSVersion();
        login.MACAddress = Host.getUniqueDeviceID();
        login.ClientIP = Host.getIPAddress(true);
        login.Culture = Locale.getDefault().toString().replace('_', '-');
        login.VirtualMachine = false;
        login.FirstLogin = this.mFirstLogin;
        boolean loginSent = false;
        if (this.mConnection != null && this.mConnection.isConnected()) {
            this.mConnection.sendMessage(login);
            loginSent = true;
        }
        if (!loginSent) {
            Log.e(TAG, "Failed to send login message.");
            this.doDisconnect(false);
        }
    }

    private void doDisconnect(boolean logout) {
        if (this.mHeartBeatTimer != null) {
            this.mHeartBeatTimer.cancel();
            this.mHeartBeatTimer = null;
        }
        if (this.mConnection != null) {
            try {
                Log.d(TAG, "doDisconnect(), [" + this.mDescription + "], Disconnecting host connection.");
                if (logout && this.mConnection.isConnected()) {
                    MsgLoginResponse2 msg = new MsgLoginResponse2();
                    msg.UserID = "";
                    msg.Result = LoginResult.Logout;
                    this.mConnection.sendMessage(msg);
                    this.mConnection.close();
                } else if (this.mConnection.isConnected()) {
                    this.mConnection.close();
                }
                this.mConnection.unregisterConnectionHandler(this.mConnectionHandler);
            }
            catch (Exception ex) {
                Log.d(TAG, "doDisconnect(), Error cleaning up host connection.", ex);
            }
            finally {
                this.mConnection = null;
            }
        }
        this.mLoggedIn = false;
    }

    private void onHeartBeatTimer() {
        NDateTime now;
        NTimeSpan idleTime;
        if (this.isConnected() && this.mHeartBeatTimer != null && (idleTime = (now = NDateTime.now()).Subtract(this.mLastRecieveTime)).getTotalSeconds() > 180.0) {
            Log.e(TAG, "onHeartBeatTimer(), [" + this.mDescription + "], " + idleTime.getTotalSeconds() + " since last message from host (max is 180.0). Restarting connection., now: " + now.toDateTimeString() + ", last msg: " + this.mLastRecieveTime.toDateTimeString());
            this.doDisconnect(false);
            this.onDisconnected("Idle for " + (int)idleTime.getTotalSeconds() + " seconds.");
            this.beginConnect();
        }
    }

    private void onMessage(Message msg) {
        if (msg.getMessageType() == MessageType.SSIChallenge) {
            Log.d(TAG, "onMessage(), [" + this.mDescription + "], Logging in using SSI challenge.");
            this.doLogin(((MsgSSIChallenge)msg).ChallengeValue);
        } else {
            try {
                if (this.mCallbackHandler != null) {
                    this.mCallbackHandler.message(this, msg);
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "onMessage(), [" + this.mDescription + "], Callback handler raised an unhandled exception.", ex);
            }
        }
    }

    private void onLoggedIn(boolean firstLogin) {
        try {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.loggedIn(this, firstLogin);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "onLoggedIn(), [" + this.mDescription + "], Callback handler raised an unhandled exception.", ex);
        }
    }

    private void onDisconnected(String reason) {
        try {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.disconnected(this, reason);
            }
        }
        catch (Exception ex) {
            Log.e(TAG, "onDisconnected(), [" + this.mDescription + "], Callback handler raised an unhandled exception.", ex);
        }
    }
}

