/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.collections;

import com.t4login.collections.Spannable;
import com.t4login.util.Range;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class TreeSetSpan<T extends Spannable>
implements Iterable<T> {
    Comparator<T> ItemComparer;
    private Node<T> RootNode;

    public TreeSetSpan() {
        this.ItemComparer = new Comparator<T>(this){

            @Override
            public int compare(T a, T b) {
                if (a instanceof Comparable && b instanceof Comparable) {
                    return ((Comparable)a).compareTo((Comparable)b);
                }
                return 0;
            }
        };
        this.RootNode = null;
    }

    public TreeSetSpan(Comparator<T> comparer) {
        this.ItemComparer = comparer;
        this.RootNode = null;
    }

    Node<T> rootNode() {
        return this.RootNode;
    }

    public Comparator<T> comparator() {
        return this.ItemComparer;
    }

    public int size() {
        return this.RootNode == null ? 0 : this.RootNode.Count;
    }

    public int indexOf(T value) {
        if (value == null || this.RootNode == null) {
            return -1;
        }
        Node<Object> node = this.RootNode;
        int pidx = 0;
        while (node != null) {
            int curridx = pidx + (node.Left != null ? node.Left.Count : 0);
            int result = this.ItemComparer.compare((Spannable)value, (Spannable)node.Item);
            if (result == 0) {
                return curridx;
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            pidx += 1 + (node.Left != null ? node.Left.Count : 0);
            node = node.Right;
        }
        return -1;
    }

    public T get(int index) {
        if (this.RootNode == null || index < 0 || index >= this.RootNode.Count) {
            throw new IndexOutOfBoundsException("Index is out of range of the values in the collection.");
        }
        Node<Object> node = this.RootNode;
        int pidx = 0;
        while (node != null) {
            int curridx = pidx + (node.Left != null ? node.Left.Count : 0);
            if (index == curridx) {
                return (T)((Spannable)node.Item);
            }
            if (index < curridx) {
                node = node.Left;
                continue;
            }
            pidx += 1 + (node.Left != null ? node.Left.Count : 0);
            node = node.Right;
        }
        throw new IndexOutOfBoundsException("Index is out of range of the values in the collection.");
    }

    public void Clear() {
        this.RootNode = null;
    }

    public T first() {
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        while (node.Left != null) {
            node = node.Left;
        }
        return (T)((Spannable)node.Item);
    }

    public T last() {
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        while (node.Right != null) {
            node = node.Right;
        }
        return (T)((Spannable)node.Item);
    }

    public String toString() {
        if (this.RootNode == null) {
            return "<empty>";
        }
        return this.PrintNode(this.RootNode);
    }

    private int NodeSpan(Node<T> node) {
        return node != null ? node.TotalSpan : 0;
    }

    private void RotateLeft(Node<T> node) {
        Node y = node.Right;
        node.Right = y.Left;
        node.Count = node.Count - y.Count + (node.Right != null ? node.Right.Count : 0);
        y.Count = y.Count + node.Count - (y.Left != null ? y.Left.Count : 0);
        node.TotalSpan = node.TotalSpan - y.TotalSpan + (node.Right != null ? node.Right.TotalSpan : 0);
        y.TotalSpan = y.TotalSpan + node.TotalSpan - (y.Left != null ? y.Left.TotalSpan : 0);
        if (y.Left != null) {
            y.Left.Parent = node;
        }
        if (y != null) {
            y.Parent = node.Parent;
        }
        if (node.Parent != null) {
            if (node == node.Parent.Left) {
                node.Parent.Left = y;
            } else {
                node.Parent.Right = y;
            }
        } else {
            this.RootNode = y;
        }
        y.Left = node;
        if (node != null) {
            node.Parent = y;
        }
    }

    private void RotateRight(Node<T> node) {
        Node y = node.Left;
        node.Left = y.Right;
        node.Count = node.Count - y.Count + (node.Left != null ? node.Left.Count : 0);
        y.Count = y.Count + node.Count - (y.Right != null ? y.Right.Count : 0);
        node.TotalSpan = node.TotalSpan - y.TotalSpan + (node.Left != null ? node.Left.TotalSpan : 0);
        y.TotalSpan = y.TotalSpan + node.TotalSpan - (y.Right != null ? y.Right.TotalSpan : 0);
        if (y.Right != null) {
            y.Right.Parent = node;
        }
        if (y != null) {
            y.Parent = node.Parent;
        }
        if (node.Parent != null) {
            if (node == node.Parent.Right) {
                node.Parent.Right = y;
            } else {
                node.Parent.Left = y;
            }
        } else {
            this.RootNode = y;
        }
        y.Right = node;
        if (node != null) {
            node.Parent = y;
        }
    }

    private String PrintNode(Node<T> n) {
        Object node = "not implemented";
        if (n.Left != null) {
            node = (String)node + this.PrintNode(n.Left);
        }
        if (n.Right != null) {
            node = (String)node + this.PrintNode(n.Right);
        }
        return node;
    }

    public void add(T value) {
        Node<T> newnode = new Node<T>(value);
        newnode.TotalSpan = value.Span();
        if (this.RootNode == null) {
            this.RootNode = newnode;
        } else {
            Node<Object> node = this.RootNode;
            while (node != null) {
                ++node.Count;
                node.TotalSpan += newnode.TotalSpan;
                int result = this.ItemComparer.compare((Spannable)newnode.Item, (Spannable)node.Item);
                if (result == 0) {
                    int childspan = this.NodeSpan(node.Left) + this.NodeSpan(node.Right);
                    int spanadj = node.TotalSpan - newnode.TotalSpan - childspan;
                    node.Item = value;
                    --node.Count;
                    node.TotalSpan = value.Span() + childspan;
                    node = node.Parent;
                    while (node != null) {
                        --node.Count;
                        node.TotalSpan -= spanadj;
                        node = node.Parent;
                    }
                    return;
                }
                if (result > 0) {
                    if (node.Right == null) {
                        node.Right = newnode;
                        newnode.Parent = node;
                        node = null;
                        continue;
                    }
                    node = node.Right;
                    continue;
                }
                if (node.Left == null) {
                    node.Left = newnode;
                    newnode.Parent = node;
                    node = null;
                    continue;
                }
                node = node.Left;
            }
        }
        Node<Object> balnode = newnode;
        while (balnode != this.RootNode && balnode.Parent.Color == NodeColor.Red) {
            Node uncle;
            if (balnode.Parent == balnode.Parent.Parent.Left) {
                uncle = balnode.Parent.Parent.Right;
                if (uncle != null && uncle.Color == NodeColor.Red) {
                    balnode.Parent.Color = NodeColor.Black;
                    uncle.Color = NodeColor.Black;
                    balnode.Parent.Parent.Color = NodeColor.Red;
                    balnode = balnode.Parent.Parent;
                    continue;
                }
                if (balnode == balnode.Parent.Right) {
                    balnode = balnode.Parent;
                    this.RotateLeft(balnode);
                }
                balnode.Parent.Color = NodeColor.Black;
                balnode.Parent.Parent.Color = NodeColor.Red;
                this.RotateRight(balnode.Parent.Parent);
                continue;
            }
            uncle = balnode.Parent.Parent.Left;
            if (uncle != null && uncle.Color == NodeColor.Red) {
                balnode.Parent.Color = NodeColor.Black;
                uncle.Color = NodeColor.Black;
                balnode.Parent.Parent.Color = NodeColor.Red;
                balnode = balnode.Parent.Parent;
                continue;
            }
            if (balnode == balnode.Parent.Left) {
                balnode = balnode.Parent;
                this.RotateRight(balnode);
            }
            balnode.Parent.Color = NodeColor.Black;
            balnode.Parent.Parent.Color = NodeColor.Red;
            this.RotateLeft(balnode.Parent.Parent);
        }
        this.RootNode.Color = NodeColor.Black;
    }

    public boolean remove(T value) {
        NodeColor tmpcolor;
        int result;
        Node<Object> node = this.RootNode;
        while (node != null && (result = this.ItemComparer.compare((Spannable)value, (Spannable)node.Item)) != 0) {
            if (result < 0) {
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        if (node == null) {
            return false;
        }
        if (node == this.RootNode && this.RootNode.Count == 1) {
            this.Clear();
            return true;
        }
        if (node.Left != null && node.Right != null) {
            Node s = node.Left;
            while (s.Right != null) {
                s = s.Right;
            }
            node.Item = s.Item;
            node = s;
        }
        node.TotalSpan = this.NodeSpan(node.Left) + this.NodeSpan(node.Right);
        --node.Count;
        Node predecesornode = node.Parent;
        while (predecesornode != null) {
            --predecesornode.Count;
            predecesornode.TotalSpan = ((Spannable)predecesornode.Item).Span() + this.NodeSpan(predecesornode.Left) + this.NodeSpan(predecesornode.Right);
            predecesornode = predecesornode.Parent;
        }
        Node parent = node.Parent;
        Node child = node.Left == null ? node.Right : node.Left;
        Node sibling = null;
        if (node.Parent != null) {
            Node node2 = sibling = node.Parent.Left == node ? node.Parent.Right : node.Parent.Left;
        }
        if (node.Color == NodeColor.Red) {
            if (node.Parent != null && node.Parent.Left == node) {
                node.Parent.Left = null;
            } else if (node.Parent != null && node.Parent.Right == node) {
                node.Parent.Right = null;
            }
            return true;
        }
        if (child != null && child.Color == NodeColor.Red) {
            if (node.Parent != null && node.Parent.Left == node) {
                node.Parent.Left = child;
                child.Parent = node.Parent;
            } else if (node.Parent != null && node.Parent.Right == node) {
                node.Parent.Right = child;
                child.Parent = node.Parent;
            } else {
                this.RootNode = child;
                child.Parent = null;
            }
            child.Color = NodeColor.Black;
            return true;
        }
        boolean leftside = false;
        if (node.Parent != null && node.Parent.Left == node) {
            leftside = true;
            node.Parent.Left = child;
        } else if (node.Parent != null && node.Parent.Right == node) {
            leftside = false;
            node.Parent.Right = child;
        }
        while (true) {
            if (parent == null) {
                return true;
            }
            if (sibling.Color == NodeColor.Red) {
                parent.Color = NodeColor.Red;
                sibling.Color = NodeColor.Black;
                if (leftside) {
                    this.RotateLeft(parent);
                    sibling = parent.Right;
                } else {
                    this.RotateRight(parent);
                    sibling = parent.Left;
                }
            }
            if (!(parent.Color != NodeColor.Black || sibling.Color != NodeColor.Black || sibling.Right != null && sibling.Right.Color != NodeColor.Black || sibling.Left != null && sibling.Left.Color != NodeColor.Black)) {
                sibling.Color = NodeColor.Red;
                node = parent;
                parent = node.Parent;
                if (node.Parent == null) continue;
                sibling = parent.Left == node ? parent.Right : parent.Left;
                leftside = parent.Left == node;
                continue;
            }
            if (!(sibling.Color != NodeColor.Black || sibling.Left != null && sibling.Left.Color != NodeColor.Black || sibling.Right != null && sibling.Right.Color != NodeColor.Black)) {
                parent.Color = NodeColor.Black;
                sibling.Color = NodeColor.Red;
                return true;
            }
            if (sibling.Color == NodeColor.Black && sibling.Left != null && sibling.Left.Color == NodeColor.Red && (sibling.Right == null || sibling.Right.Color == NodeColor.Black) && leftside) {
                Node sibleftchild = sibling.Left;
                this.RotateRight(sibling);
                sibling.Color = NodeColor.Red;
                sibleftchild.Color = NodeColor.Black;
                sibling = sibleftchild;
            }
            if (!(sibling.Color != NodeColor.Black || sibling.Right == null || sibling.Right.Color != NodeColor.Red || sibling.Left != null && sibling.Left.Color != NodeColor.Black || leftside)) {
                Node sibrightchild = sibling.Right;
                this.RotateLeft(sibling);
                sibling.Color = NodeColor.Red;
                sibrightchild.Color = NodeColor.Black;
                sibling = sibrightchild;
            }
            if (sibling.Color == NodeColor.Black && sibling.Right != null && sibling.Right.Color == NodeColor.Red && leftside) {
                this.RotateLeft(parent);
                tmpcolor = parent.Color;
                parent.Color = sibling.Color;
                sibling.Color = tmpcolor;
                sibling.Right.Color = NodeColor.Black;
                return true;
            }
            if (sibling.Color == NodeColor.Black && sibling.Left != null && sibling.Left.Color == NodeColor.Red && !leftside) break;
        }
        this.RotateRight(parent);
        tmpcolor = parent.Color;
        parent.Color = sibling.Color;
        sibling.Color = tmpcolor;
        sibling.Left.Color = NodeColor.Black;
        return true;
    }

    public boolean Contains(T value) {
        if (value == null || this.RootNode == null) {
            return false;
        }
        Node<Object> node = this.RootNode;
        while (node != null) {
            int result = this.ItemComparer.compare((Spannable)value, (Spannable)node.Item);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = new Iterator<T>(){
            private Node<T> nextNode;
            {
                this.nextNode = TreeSetSpan.this.RootNode;
                if (this.nextNode != null) {
                    while (this.nextNode.Left != null) {
                        this.nextNode = this.nextNode.Left;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public T next() {
                if (this.nextNode == null) {
                    throw new NoSuchElementException("There is no next item in the collection.");
                }
                Spannable nextValue = (Spannable)this.nextNode.Item;
                if (this.nextNode.Right != null) {
                    this.nextNode = this.nextNode.Right;
                    while (this.nextNode.Left != null) {
                        this.nextNode = this.nextNode.Left;
                    }
                } else if (this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Left) {
                    this.nextNode = this.nextNode.Parent;
                } else {
                    while (this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Right) {
                        this.nextNode = this.nextNode.Parent;
                    }
                    this.nextNode = this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Left ? this.nextNode.Parent : null;
                }
                return nextValue;
            }

            @Override
            public void remove() {
            }
        };
        return it;
    }

    public int totalSpan() {
        Node<T> root = this.RootNode;
        return root != null ? root.TotalSpan : 0;
    }

    public Range<Integer> getSpanRange(T value) {
        Node<Object> node = this.RootNode;
        int sd = 0;
        while (node != null) {
            int result = this.ItemComparer.compare((Spannable)value, (Spannable)node.Item);
            if (result == 0) {
                int ss = sd + this.NodeSpan(node.Left);
                int se = ss + node.TotalSpan - this.NodeSpan(node.Left) - this.NodeSpan(node.Right);
                return new Range<Integer>(ss, se);
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            sd = sd + node.TotalSpan - this.NodeSpan(node.Right);
            node = node.Right;
        }
        return Range.empty();
    }

    public Range<Integer> getSpanRange(T a, T b) {
        Range<Integer> spanrng = this.getSpanRange(a);
        spanrng = spanrng.expanded(this.getSpanRange(b));
        return spanrng;
    }

    public T getItemAtSpan(int span) {
        Node<Object> node = this.RootNode;
        if (node == null || span < 0 || span >= this.RootNode.TotalSpan) {
            return null;
        }
        int sd = 0;
        while (node != null) {
            int ss = sd + this.NodeSpan(node.Left);
            if (span < ss) {
                node = node.Left;
                continue;
            }
            if (span < ss) continue;
            int se = ss + node.TotalSpan - this.NodeSpan(node.Left) - this.NodeSpan(node.Right);
            if (span < se) {
                return (T)((Spannable)node.Item);
            }
            sd = se;
            node = node.Right;
        }
        return null;
    }

    private static final class Node<TNode> {
        public NodeColor Color = NodeColor.Red;
        public Node<TNode> Left = null;
        public Node<TNode> Right = null;
        public Node<TNode> Parent = null;
        public int Count = 1;
        public int TotalSpan = 0;
        public TNode Item = null;

        public Node(TNode item) {
            this.Item = item;
        }

        public String toString() {
            return String.format(Locale.US, "(%s,%s,%d,%d)", this.Item, this.Color == NodeColor.Red ? "R" : "B", this.Count, this.TotalSpan);
        }
    }

    static enum NodeColor {
        Black,
        Red;

    }
}

