/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.collections;

import com.t4login.util.Range;
import com.t4login.util.RangeType;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Stack;

public class TreeSetDictionary<T, TKey>
implements Iterable<T> {
    private final Comparator ItemComparer;
    private Node<T> RootNode;

    public TreeSetDictionary() {
        this.ItemComparer = new Comparator<T>(this){

            @Override
            public int compare(T a, T b) {
                if (a instanceof Comparable && b instanceof Comparable) {
                    return ((Comparable)a).compareTo((Comparable)b);
                }
                return 0;
            }
        };
        this.RootNode = null;
    }

    public TreeSetDictionary(Comparator comparer) {
        this.ItemComparer = comparer;
        this.RootNode = null;
    }

    Node<T> rootNode() {
        return this.RootNode;
    }

    public Comparator comparator() {
        return this.ItemComparer;
    }

    public int size() {
        return this.RootNode == null ? 0 : this.RootNode.Count;
    }

    public int indexOf(T value) {
        if (value == null || this.RootNode == null) {
            return -1;
        }
        Node<Object> node = this.RootNode;
        int pidx = 0;
        while (node != null) {
            int curridx = pidx + (node.Left != null ? node.Left.Count : 0);
            int result = this.ItemComparer.compare(value, node.Item);
            if (result == 0) {
                return curridx;
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            pidx += 1 + (node.Left != null ? node.Left.Count : 0);
            node = node.Right;
        }
        return -1;
    }

    public Range<Integer> boundingIndexOf(TKey key) {
        if (key == null || this.RootNode == null) {
            return Range.empty();
        }
        Node<Object> node = this.RootNode;
        int pidx = 0;
        Node<T> pre = null;
        int preidx = 0;
        Node<T> fol = null;
        int folidx = 0;
        while (node != null) {
            int curridx = pidx + (node.Left != null ? node.Left.Count : 0);
            int result = this.ItemComparer.compare(key, node.Item);
            if (result == 0) {
                return Range.of(curridx, curridx);
            }
            if (result < 0) {
                fol = node;
                folidx = curridx;
                node = node.Left;
                continue;
            }
            pre = node;
            preidx = curridx;
            pidx += 1 + (node.Left != null ? node.Left.Count : 0);
            node = node.Right;
        }
        if (pre != null) {
            if (fol == null) {
                return Range.of(preidx, Integer.MAX_VALUE);
            }
            return Range.of(preidx, folidx);
        }
        return Range.of(Integer.MIN_VALUE, 0);
    }

    public T get(int index) {
        if (this.RootNode == null || index < 0 || index >= this.RootNode.Count) {
            throw new IndexOutOfBoundsException("Index is out of range of the values in the collection.");
        }
        Node<Object> node = this.RootNode;
        int pidx = 0;
        while (node != null) {
            int curridx = pidx + (node.Left != null ? node.Left.Count : 0);
            if (index == curridx) {
                return (T)node.Item;
            }
            if (index < curridx) {
                node = node.Left;
                continue;
            }
            pidx += 1 + (node.Left != null ? node.Left.Count : 0);
            node = node.Right;
        }
        throw new IndexOutOfBoundsException("Index is out of range of the values in the collection.");
    }

    public void clear() {
        this.RootNode = null;
    }

    public T first() {
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        while (node.Left != null) {
            node = node.Left;
        }
        return (T)node.Item;
    }

    public T last() {
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        while (node.Right != null) {
            node = node.Right;
        }
        return (T)node.Item;
    }

    public String toString() {
        return this.getClass().getName() + ", count: " + this.size();
    }

    public T get(TKey key) {
        Node<Object> node = this.RootNode;
        while (node != null) {
            int result = this.ItemComparer.compare(key, node.Item);
            if (result == 0) {
                return (T)node.Item;
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T getNext(TKey key) {
        int result;
        if (this.RootNode == null) {
            return null;
        }
        Node node = this.RootNode;
        Stack stack = new Stack();
        while (node != null && (result = this.ItemComparer.compare(key, node.Item)) != 0) {
            if (result < 0) {
                stack.push(node);
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        if (node == null) {
            if (stack.size() == 0) {
                return null;
            }
            node = (Node)stack.pop();
            return (T)node.Item;
        }
        if (node == null) return null;
        if (node.Right == null) {
            if (stack.size() <= 0) return null;
            node = (Node)stack.pop();
            return (T)node.Item;
        } else {
            node = node.Right;
            while (node.Left != null) {
                stack.push(node);
                node = node.Left;
            }
        }
        return (T)node.Item;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T getPrevious(TKey key) {
        int result;
        if (this.RootNode == null) {
            return null;
        }
        Node node = this.RootNode;
        Stack stack = new Stack();
        while (node != null && (result = this.ItemComparer.compare(key, node.Item)) != 0) {
            if (result < 0) {
                node = node.Left;
                continue;
            }
            stack.push(node);
            node = node.Right;
        }
        if (node == null) {
            if (stack.size() == 0) {
                return null;
            }
            node = (Node)stack.pop();
            return (T)node.Item;
        }
        if (node == null) return null;
        if (node.Left == null) {
            if (stack.size() <= 0) return null;
            node = (Node)stack.pop();
            return (T)node.Item;
        } else {
            node = node.Left;
            while (node.Right != null) {
                stack.push(node);
                node = node.Right;
            }
        }
        return (T)node.Item;
    }

    public T nearest(TKey key, DistanceComparer<T, TKey> distComp) {
        int result;
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        Stack<Node<T>> lStack = new Stack<Node<T>>();
        Stack<Node<T>> rStack = new Stack<Node<T>>();
        while (node != null && (result = this.ItemComparer.compare(key, node.Item)) != 0) {
            if (result < 0) {
                lStack.push(node);
                node = node.Left;
                continue;
            }
            rStack.push(node);
            node = node.Right;
        }
        if (node != null) {
            return (T)node.Item;
        }
        Node preceeding = null;
        Node next = null;
        if (rStack.size() > 0) {
            preceeding = (Node)rStack.pop();
        }
        if (lStack.size() > 0) {
            next = (Node)lStack.pop();
        }
        if (preceeding != null && next != null) {
            int distRes = distComp.compareDistanceTo(key, preceeding.Item, next.Item);
            if (distRes <= 0) {
                return (T)preceeding.Item;
            }
            return (T)next.Item;
        }
        if (preceeding != null) {
            return (T)preceeding.Item;
        }
        if (next != null) {
            return (T)next.Item;
        }
        return null;
    }

    public T nearestGreater(TKey key) {
        int result;
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        Stack<Node<T>> lStack = new Stack<Node<T>>();
        Stack<Node<T>> rStack = new Stack<Node<T>>();
        while (node != null && (result = this.ItemComparer.compare(key, node.Item)) != 0) {
            if (result < 0) {
                lStack.push(node);
                node = node.Left;
                continue;
            }
            rStack.push(node);
            node = node.Right;
        }
        if (node != null) {
            return (T)node.Item;
        }
        if (lStack.size() > 0) {
            return (T)((Node)lStack.pop()).Item;
        }
        if (rStack.size() > 0) {
            return (T)((Node)rStack.pop()).Item;
        }
        return null;
    }

    public T nearestSmaller(TKey key) {
        int result;
        if (this.RootNode == null) {
            return null;
        }
        Node<Object> node = this.RootNode;
        Stack<Node<T>> lStack = new Stack<Node<T>>();
        Stack<Node<T>> rStack = new Stack<Node<T>>();
        while (node != null && (result = this.ItemComparer.compare(key, node.Item)) != 0) {
            if (result < 0) {
                lStack.push(node);
                node = node.Left;
                continue;
            }
            rStack.push(node);
            node = node.Right;
        }
        if (node != null) {
            return (T)node.Item;
        }
        if (rStack.size() > 0) {
            return (T)((Node)rStack.pop()).Item;
        }
        if (lStack.size() > 0) {
            return (T)((Node)lStack.pop()).Item;
        }
        return null;
    }

    public Iterator<T> getValuesBetween(final TKey start, final TKey end, final RangeType rangetype) {
        Iterator it = new Iterator<T>(){
            private Node<T> nextNode;
            {
                int result;
                Node<Object> node = TreeSetDictionary.this.RootNode;
                while (node != null && (result = TreeSetDictionary.this.ItemComparer.compare(start, node.Item)) != 0) {
                    if (result < 0) {
                        int endResult;
                        if (node.Left != null) {
                            node = node.Left;
                            continue;
                        }
                        if (rangetype == RangeType.Extended) {
                            if (node.Parent != null && node == node.Parent.Right) {
                                node = node.Parent;
                                break;
                            }
                            if (node.Parent == null || node != node.Parent.Left) break;
                            Node<Object> wb = node;
                            while (wb.Parent != null && wb == wb.Parent.Left) {
                                wb = wb.Parent;
                            }
                            if (wb.Parent == null || wb != wb.Parent.Right) break;
                            node = wb.Parent;
                            break;
                        }
                        if (rangetype != RangeType.Enclosed || (endResult = TreeSetDictionary.this.ItemComparer.compare(end, node.Item)) >= 0) break;
                        node = null;
                        break;
                    }
                    if (node.Right != null) {
                        node = node.Right;
                        continue;
                    }
                    if (rangetype != RangeType.Enclosed) break;
                    while (node.Parent != null && node == node.Parent.Right) {
                        node = node.Parent;
                    }
                    if (node.Parent != null && node == node.Parent.Left) {
                        node = node.Parent;
                        break;
                    }
                    node = null;
                    break;
                }
                this.nextNode = node;
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != null;
            }

            @Override
            public T next() {
                int nextResult;
                if (this.nextNode == null) {
                    throw new NoSuchElementException("There is no next item in the collection.");
                }
                Object nextValue = this.nextNode.Item;
                int currResult = TreeSetDictionary.this.ItemComparer.compare(this.nextNode.Item, end);
                if (currResult < 0) {
                    if (this.nextNode.Right != null) {
                        this.nextNode = this.nextNode.Right;
                        while (this.nextNode.Left != null) {
                            this.nextNode = this.nextNode.Left;
                        }
                    } else if (this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Left) {
                        this.nextNode = this.nextNode.Parent;
                    } else {
                        while (this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Right) {
                            this.nextNode = this.nextNode.Parent;
                        }
                        this.nextNode = this.nextNode.Parent != null && this.nextNode == this.nextNode.Parent.Left ? this.nextNode.Parent : null;
                    }
                } else {
                    this.nextNode = null;
                }
                if (this.nextNode != null && (nextResult = TreeSetDictionary.this.ItemComparer.compare(this.nextNode.Item, end)) > 0 && rangetype != RangeType.Extended) {
                    this.nextNode = null;
                }
                return nextValue;
            }

            @Override
            public void remove() {
            }
        };
        return it;
    }

    private void RotateLeft(Node<T> node) {
        Node y = node.Right;
        node.Right = y.Left;
        node.Count = node.Count - y.Count + (node.Right != null ? node.Right.Count : 0);
        y.Count = y.Count + node.Count - (y.Left != null ? y.Left.Count : 0);
        if (y.Left != null) {
            y.Left.Parent = node;
        }
        if (y != null) {
            y.Parent = node.Parent;
        }
        if (node.Parent != null) {
            if (node == node.Parent.Left) {
                node.Parent.Left = y;
            } else {
                node.Parent.Right = y;
            }
        } else {
            this.RootNode = y;
        }
        y.Left = node;
        if (node != null) {
            node.Parent = y;
        }
    }

    private void RotateRight(Node<T> node) {
        Node y = node.Left;
        node.Left = y.Right;
        node.Count = node.Count - y.Count + (node.Left != null ? node.Left.Count : 0);
        y.Count = y.Count + node.Count - (y.Right != null ? y.Right.Count : 0);
        if (y.Right != null) {
            y.Right.Parent = node;
        }
        if (y != null) {
            y.Parent = node.Parent;
        }
        if (node.Parent != null) {
            if (node == node.Parent.Right) {
                node.Parent.Right = y;
            } else {
                node.Parent.Left = y;
            }
        } else {
            this.RootNode = y;
        }
        y.Right = node;
        if (node != null) {
            node.Parent = y;
        }
    }

    public void add(T value) {
        Node<T> newnode = new Node<T>(value);
        if (this.RootNode == null) {
            this.RootNode = newnode;
        } else {
            Node<Object> node = this.RootNode;
            while (node != null) {
                ++node.Count;
                int result = this.ItemComparer.compare(newnode.Item, node.Item);
                if (result == 0) {
                    node.Item = value;
                    --node.Count;
                    node = node.Parent;
                    while (node != null) {
                        --node.Count;
                        node = node.Parent;
                    }
                    return;
                }
                if (result > 0) {
                    if (node.Right == null) {
                        node.Right = newnode;
                        newnode.Parent = node;
                        node = null;
                        continue;
                    }
                    node = node.Right;
                    continue;
                }
                if (node.Left == null) {
                    node.Left = newnode;
                    newnode.Parent = node;
                    node = null;
                    continue;
                }
                node = node.Left;
            }
        }
        Node<Object> balnode = newnode;
        while (balnode != this.RootNode && balnode.Parent.Color == NodeColor.Red) {
            Node uncle;
            if (balnode.Parent == balnode.Parent.Parent.Left) {
                uncle = balnode.Parent.Parent.Right;
                if (uncle != null && uncle.Color == NodeColor.Red) {
                    balnode.Parent.Color = NodeColor.Black;
                    uncle.Color = NodeColor.Black;
                    balnode.Parent.Parent.Color = NodeColor.Red;
                    balnode = balnode.Parent.Parent;
                    continue;
                }
                if (balnode == balnode.Parent.Right) {
                    balnode = balnode.Parent;
                    this.RotateLeft(balnode);
                }
                balnode.Parent.Color = NodeColor.Black;
                balnode.Parent.Parent.Color = NodeColor.Red;
                this.RotateRight(balnode.Parent.Parent);
                continue;
            }
            uncle = balnode.Parent.Parent.Left;
            if (uncle != null && uncle.Color == NodeColor.Red) {
                balnode.Parent.Color = NodeColor.Black;
                uncle.Color = NodeColor.Black;
                balnode.Parent.Parent.Color = NodeColor.Red;
                balnode = balnode.Parent.Parent;
                continue;
            }
            if (balnode == balnode.Parent.Left) {
                balnode = balnode.Parent;
                this.RotateRight(balnode);
            }
            balnode.Parent.Color = NodeColor.Black;
            balnode.Parent.Parent.Color = NodeColor.Red;
            this.RotateLeft(balnode.Parent.Parent);
        }
        this.RootNode.Color = NodeColor.Black;
    }

    public boolean remove(T value) {
        NodeColor tmpcolor;
        int result;
        Node<Object> node = this.RootNode;
        while (node != null && (result = this.ItemComparer.compare(value, node.Item)) != 0) {
            if (result < 0) {
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        if (node == null) {
            return false;
        }
        if (node == this.RootNode && this.RootNode.Count == 1) {
            this.clear();
            return true;
        }
        if (node.Left != null && node.Right != null) {
            Node s = node.Left;
            while (s.Right != null) {
                s = s.Right;
            }
            node.Item = s.Item;
            node = s;
        }
        --node.Count;
        Node predecesornode = node.Parent;
        while (predecesornode != null) {
            --predecesornode.Count;
            predecesornode = predecesornode.Parent;
        }
        Node parent = node.Parent;
        Node child = node.Left == null ? node.Right : node.Left;
        Node sibling = null;
        if (node.Parent != null) {
            Node node2 = sibling = node.Parent.Left == node ? node.Parent.Right : node.Parent.Left;
        }
        if (node.Color == NodeColor.Red) {
            if (node.Parent != null && node.Parent.Left == node) {
                node.Parent.Left = null;
            } else if (node.Parent != null && node.Parent.Right == node) {
                node.Parent.Right = null;
            }
            return true;
        }
        if (child != null && child.Color == NodeColor.Red) {
            if (node.Parent != null && node.Parent.Left == node) {
                node.Parent.Left = child;
                child.Parent = node.Parent;
            } else if (node.Parent != null && node.Parent.Right == node) {
                node.Parent.Right = child;
                child.Parent = node.Parent;
            } else {
                this.RootNode = child;
                child.Parent = null;
            }
            child.Color = NodeColor.Black;
            return true;
        }
        boolean leftside = false;
        if (node.Parent != null && node.Parent.Left == node) {
            leftside = true;
            node.Parent.Left = child;
        } else if (node.Parent != null && node.Parent.Right == node) {
            leftside = false;
            node.Parent.Right = child;
        }
        while (true) {
            if (parent == null) {
                return true;
            }
            if (sibling.Color == NodeColor.Red) {
                parent.Color = NodeColor.Red;
                sibling.Color = NodeColor.Black;
                if (leftside) {
                    this.RotateLeft(parent);
                    sibling = parent.Right;
                } else {
                    this.RotateRight(parent);
                    sibling = parent.Left;
                }
            }
            if (!(parent.Color != NodeColor.Black || sibling.Color != NodeColor.Black || sibling.Right != null && sibling.Right.Color != NodeColor.Black || sibling.Left != null && sibling.Left.Color != NodeColor.Black)) {
                sibling.Color = NodeColor.Red;
                node = parent;
                parent = node.Parent;
                if (node.Parent == null) continue;
                sibling = parent.Left == node ? parent.Right : parent.Left;
                leftside = parent.Left == node;
                continue;
            }
            if (!(sibling.Color != NodeColor.Black || sibling.Left != null && sibling.Left.Color != NodeColor.Black || sibling.Right != null && sibling.Right.Color != NodeColor.Black)) {
                parent.Color = NodeColor.Black;
                sibling.Color = NodeColor.Red;
                return true;
            }
            if (sibling.Color == NodeColor.Black && sibling.Left != null && sibling.Left.Color == NodeColor.Red && (sibling.Right == null || sibling.Right.Color == NodeColor.Black) && leftside) {
                Node sibleftchild = sibling.Left;
                this.RotateRight(sibling);
                sibling.Color = NodeColor.Red;
                sibleftchild.Color = NodeColor.Black;
                sibling = sibleftchild;
            }
            if (!(sibling.Color != NodeColor.Black || sibling.Right == null || sibling.Right.Color != NodeColor.Red || sibling.Left != null && sibling.Left.Color != NodeColor.Black || leftside)) {
                Node sibrightchild = sibling.Right;
                this.RotateLeft(sibling);
                sibling.Color = NodeColor.Red;
                sibrightchild.Color = NodeColor.Black;
                sibling = sibrightchild;
            }
            if (sibling.Color == NodeColor.Black && sibling.Right != null && sibling.Right.Color == NodeColor.Red && leftside) {
                this.RotateLeft(parent);
                tmpcolor = parent.Color;
                parent.Color = sibling.Color;
                sibling.Color = tmpcolor;
                sibling.Right.Color = NodeColor.Black;
                return true;
            }
            if (sibling.Color == NodeColor.Black && sibling.Left != null && sibling.Left.Color == NodeColor.Red && !leftside) break;
        }
        this.RotateRight(parent);
        tmpcolor = parent.Color;
        parent.Color = sibling.Color;
        sibling.Color = tmpcolor;
        sibling.Left.Color = NodeColor.Black;
        return true;
    }

    public boolean Contains(T value) {
        if (value == null || this.RootNode == null) {
            return false;
        }
        Node<Object> node = this.RootNode;
        while (node != null) {
            int result = this.ItemComparer.compare(value, node.Item);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                node = node.Left;
                continue;
            }
            node = node.Right;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = new Iterator<T>(){
            private Stack<Node<T>> stack = new Stack();
            private Node<T> currNode;
            {
                this.currNode = TreeSetDictionary.this.RootNode;
                if (this.currNode != null) {
                    while (this.currNode != null) {
                        this.stack.push(this.currNode);
                        this.currNode = this.currNode.Left;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.stack.size() > 0 || this.currNode != null && this.currNode.Right != null;
            }

            @Override
            public T next() {
                if (this.currNode == null && this.stack.size() == 0) {
                    throw new NoSuchElementException("There is no next item in the collection.");
                }
                if (this.currNode == null) {
                    this.currNode = this.stack.pop();
                } else if (this.currNode.Right != null) {
                    this.currNode = this.currNode.Right;
                    while (this.currNode.Left != null) {
                        this.stack.push(this.currNode);
                        this.currNode = this.currNode.Left;
                    }
                } else {
                    this.currNode = this.stack.pop();
                }
                return this.currNode.Item;
            }

            @Override
            public void remove() {
            }
        };
        return it;
    }

    private static final class Node<TNode> {
        public NodeColor Color = NodeColor.Red;
        public Node<TNode> Left = null;
        public Node<TNode> Right = null;
        public Node<TNode> Parent = null;
        public int Count = 1;
        public TNode Item = null;

        public Node(TNode item) {
            this.Item = item;
        }

        public String toString() {
            return String.format(Locale.US, "(%s,%s,%d)", this.Item, this.Color == NodeColor.Red ? "R" : "B", this.Count);
        }
    }

    public static interface DistanceComparer<T, TKey> {
        public int compareDistanceTo(TKey var1, T var2, T var3);
    }

    static enum NodeColor {
        Black,
        Red;

    }
}

