/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public abstract class ImmutableMap<K extends Comparable<K>, V> {
    public abstract int count();

    public abstract ImmutableMap<K, V> add(K var1, V var2);

    public abstract V get(K var1);

    public abstract Iterable<V> getValues();

    public static <K extends Comparable<K>, V> ImmutableMap<K, V> empty() {
        return new Empty();
    }

    public boolean isEmpty() {
        return this instanceof Empty;
    }

    public ImmutableMap<K, V> remove(K key) {
        if (key == null) {
            return this;
        }
        return this.remove(this, key);
    }

    private ImmutableMap<K, V> remove(ImmutableMap<K, V> map, K key) {
        if (map instanceof Empty) {
            return map;
        }
        Node nodeMap = (Node)map;
        int cmp = key.compareTo(nodeMap.key);
        if (cmp < 0) {
            return new Node(nodeMap.key, nodeMap.value, this.remove(nodeMap.left, key), nodeMap.right);
        }
        if (cmp > 0) {
            return new Node(nodeMap.key, nodeMap.value, nodeMap.left, this.remove(nodeMap.right, key));
        }
        if (nodeMap.left instanceof Empty) {
            return nodeMap.right;
        }
        if (nodeMap.right instanceof Empty) {
            return nodeMap.left;
        }
        Node minLargerNode = this.findMin(nodeMap.right);
        return new Node(minLargerNode.key, minLargerNode.value, nodeMap.left, this.removeMin(nodeMap.right));
    }

    private Node<K, V> findMin(ImmutableMap<K, V> map) {
        if (map instanceof Empty) {
            return null;
        }
        Node nodeMap = (Node)map;
        while (nodeMap.left instanceof Node) {
            nodeMap = (Node)nodeMap.left;
        }
        return nodeMap;
    }

    private ImmutableMap<K, V> removeMin(ImmutableMap<K, V> map) {
        if (map instanceof Empty) {
            return map;
        }
        Node nodeMap = (Node)map;
        if (nodeMap.left instanceof Empty) {
            return nodeMap.right;
        }
        return new Node(nodeMap.key, nodeMap.value, this.removeMin(nodeMap.left), nodeMap.right);
    }

    private static class Empty<K extends Comparable<K>, V>
    extends ImmutableMap<K, V> {
        private Empty() {
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public ImmutableMap<K, V> add(K key, V value) {
            return new Node<K, V>(key, value, this, this);
        }

        @Override
        public V get(K key) {
            return null;
        }

        @Override
        public Iterable<V> getValues() {
            return new ArrayList();
        }
    }

    private static class Node<K extends Comparable<K>, V>
    extends ImmutableMap<K, V> {
        private final K key;
        private final V value;
        private final ImmutableMap<K, V> left;
        private final ImmutableMap<K, V> right;

        private Node(K key, V value, ImmutableMap<K, V> left, ImmutableMap<K, V> right) {
            this.key = key;
            this.value = value;
            this.left = left;
            this.right = right;
        }

        @Override
        public int count() {
            return 1 + this.left.count() + this.right.count();
        }

        @Override
        public ImmutableMap<K, V> add(K newKey, V newValue) {
            int cmp = newKey.compareTo(this.key);
            if (cmp < 0) {
                return new Node<K, V>(this.key, this.value, this.left.add(newKey, newValue), this.right);
            }
            if (cmp > 0) {
                return new Node<K, V>(this.key, this.value, this.left, this.right.add(newKey, newValue));
            }
            return new Node<K, V>(newKey, newValue, this.left, this.right);
        }

        @Override
        public V get(K searchKey) {
            int cmp = searchKey.compareTo(this.key);
            if (cmp < 0) {
                return this.left.get(searchKey);
            }
            if (cmp > 0) {
                return this.right.get(searchKey);
            }
            return this.value;
        }

        @Override
        public Iterable<V> getValues() {
            return new Iterable<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new InOrderValueIterator(this, this);
                }
            };
        }

        private class InOrderValueIterator
        implements Iterator<V> {
            private final Stack<Node<K, V>> stack = new Stack();

            public InOrderValueIterator(Node node, ImmutableMap<K, V> root) {
                if (root instanceof Node) {
                    this.pushLeftChildren((Node)root);
                }
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public V next() {
                if (this.stack.isEmpty()) {
                    throw new NoSuchElementException("No more elements");
                }
                Node node = this.stack.pop();
                if (node.right instanceof Node) {
                    this.pushLeftChildren((Node)node.right);
                }
                return node.value;
            }

            private void pushLeftChildren(Node<K, V> node) {
                while (node != null) {
                    this.stack.push(node);
                    if (node.left instanceof Node) {
                        node = (Node)node.left;
                        continue;
                    }
                    node = null;
                }
            }
        }
    }
}

