/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.collections;

import com.t4login.collections.ImmutableLinkedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ImmutableLinkedListCollector<T>
implements Collector<T, List<T>, ImmutableLinkedList<T>> {
    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<T>, ImmutableLinkedList<T>> finisher() {
        return list -> {
            ImmutableLinkedList result = ImmutableLinkedList.empty();
            for (Object element : list) {
                result = result.add(element);
            }
            return result;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.unmodifiableSet(EnumSet.noneOf(Collector.Characteristics.class));
    }
}

